/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.demo.robot.replication.lifecycle;

import java.util.ArrayList;
import java.util.List;
import org.jflux.api.core.config.Configuration;
import org.jflux.impl.messaging.rk.config.MessagingLifecycleGroupConfigUtils;
import org.jflux.impl.services.rk.lifecycle.config.RKManagedGroupConfigUtils;
import org.robokind.demo.robot.replication.lifecycle.ReplicationReceiverLifecycleUtils;

public class ReplicationReceiverGroupLifecycleUtils {
    public static final String REPLICATION_DESTINATION_ID = "replicationDestinationId";
    public static final String REPLICATION_CONNECTION_ID = "replicationConnectionId";
    public static final String REPLICATION_SESSION_ID = "replicationSessionId";
    public static final String REPLICATION_ROUTER_ID = "replicationRouterId";
    public static final String EVENT_LIST_DECODER_ID = "eventListDecoderId";
    public static final String REPLICATION_RECEIVER_ID = "replicationReceiverId";
    public static final String RECEIVER_LIST_DECODER_LINK_ID = "receiverListDecoderLinkId";
    public static final String LIST_DECODER_ROUTER_LINK_ID = "listDecoderRouterLinkId";
    public static final String LINK_DECODER_ID = "decoderLinkId";
    public static final String LINK_ROUTE_ID = "routeLinkId";
    public static final String GROUP_TYPE = "ReplicationReceiverGroup";
    private static final String theIdFormat = "%s/ReplicationReceiverGroup/%s";

    public static String id(String groupId, String part) {
        return String.format(theIdFormat, groupId, part);
    }

    public static List<Configuration<String>> getReplicationReceiverLifecycleConfigs(String groupId) {
        return ReplicationReceiverLifecycleUtils.getLifecycleConfigs(REPLICATION_ROUTER_ID, ReplicationReceiverGroupLifecycleUtils.id(groupId, REPLICATION_ROUTER_ID), EVENT_LIST_DECODER_ID, ReplicationReceiverGroupLifecycleUtils.id(groupId, EVENT_LIST_DECODER_ID), REPLICATION_RECEIVER_ID, ReplicationReceiverGroupLifecycleUtils.id(groupId, REPLICATION_RECEIVER_ID), "destinationId", ReplicationReceiverGroupLifecycleUtils.id(groupId, REPLICATION_DESTINATION_ID), "connectionId", ReplicationReceiverGroupLifecycleUtils.id(groupId, REPLICATION_SESSION_ID), ReplicationReceiverGroupLifecycleUtils.id(groupId, RECEIVER_LIST_DECODER_LINK_ID), ReplicationReceiverGroupLifecycleUtils.id(groupId, LIST_DECODER_ROUTER_LINK_ID));
    }

    public static List<Configuration<String>> getJMSLifecycleConfigs(String groupId, String destinationConfId, String connectionConfId) {
        ArrayList<Configuration<String>> l = new ArrayList<Configuration<String>>();
        l.add(RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)MessagingLifecycleGroupConfigUtils.buildDestinationLifecycleConfig((String)destinationConfId, (String)ReplicationReceiverGroupLifecycleUtils.id(groupId, REPLICATION_DESTINATION_ID))));
        l.add(RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)MessagingLifecycleGroupConfigUtils.buildConnectionLifecycleConfig((String)connectionConfId, (String)ReplicationReceiverGroupLifecycleUtils.id(groupId, REPLICATION_CONNECTION_ID))));
        l.add(RKManagedGroupConfigUtils.makeSelfBuildingLifecycle((Configuration)MessagingLifecycleGroupConfigUtils.buildSessionLifecycleConfig((String)ReplicationReceiverGroupLifecycleUtils.id(groupId, REPLICATION_CONNECTION_ID), (String)ReplicationReceiverGroupLifecycleUtils.id(groupId, REPLICATION_SESSION_ID))));
        return l;
    }

    public static Configuration<String> getReplicationDecoderLinkLifecycleConfig(String groupId, String decoderId, String encodeConfigId) {
        return ReplicationReceiverLifecycleUtils.buildDecoderRouteLinkLifecycleConfig(LINK_DECODER_ID, ReplicationReceiverGroupLifecycleUtils.id(groupId, "decoderLinkId/" + decoderId), REPLICATION_ROUTER_ID, ReplicationReceiverGroupLifecycleUtils.id(groupId, REPLICATION_ROUTER_ID), "messagingSerializationConfig", encodeConfigId);
    }

    public static Configuration<String> getReplicationRouteLinkLifecycleConfig(String groupId, String linkId, String routingKey, String consumerIdKey, String consumerId) {
        return ReplicationReceiverLifecycleUtils.buildEventRouteLinkLifecycleConfig(LINK_DECODER_ID, ReplicationReceiverGroupLifecycleUtils.id(groupId, "routeLinkId/" + linkId), REPLICATION_ROUTER_ID, ReplicationReceiverGroupLifecycleUtils.id(groupId, REPLICATION_ROUTER_ID), consumerIdKey, consumerId, routingKey);
    }
}

