/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.bind.apache_qpid;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.robokind.bind.apache_avro.AvroUtils;

public class QpidUtils {
    public static <T extends IndexedRecord> void packAvroMessage(T t, BytesMessage message) throws IOException, JMSException {
        if (message == null) {
            throw new NullPointerException();
        }
        byte[] bytes = QpidUtils.packAvroBytes(t);
        message.writeBytes(bytes);
    }

    public static <T extends IndexedRecord> byte[] packAvroBytes(T t) throws IOException {
        if (t == null) {
            throw new NullPointerException();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AvroUtils.writeToStream(t, t.getSchema(), out, false);
        return out.toByteArray();
    }

    public static <T extends IndexedRecord> T unpackAvroMessage(Class<T> c, T reuse, Schema schema, BytesMessage message) throws JMSException, Exception {
        long len = message.getBodyLength();
        byte[] data = new byte[(int)len];
        int read = message.readBytes(data);
        if ((long)read != len) {
            String error = String.format("Could not read entire Avro message.  Expected %d bytes, found %d bytes.", len, read);
            throw new Exception(error);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        return AvroUtils.readFromStream(c, reuse, schema, in, false);
    }
}

