/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.bind.apache_avro;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecordBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroUtils {
    private static final Logger theLogger = LoggerFactory.getLogger(AvroUtils.class);

    public static <T extends IndexedRecord> T readFromStream(Class<T> c, T reuse, Schema schema, InputStream in, boolean json) throws IOException {
        return AvroUtils.readFromStream(c, reuse, schema, in, json, null);
    }

    public static <T extends IndexedRecord> T readFromStream(Class<T> c, T reuse, Schema schema, InputStream in, boolean json, ClassLoader classLoader) throws IOException {
        DecoderFactory dFact = DecoderFactory.get();
        GenericDatumReader r = null;
        if (c != null && SpecificRecordBase.class.isAssignableFrom(c) || classLoader != null && schema != null) {
            r = AvroUtils.buildSpecificReader(c, schema, classLoader);
        }
        if (r == null && schema != null) {
            r = new GenericDatumReader(schema);
        }
        JsonDecoder wrapped = json ? dFact.jsonDecoder(schema, in) : dFact.binaryDecoder(in, null);
        return (T)((IndexedRecord)r.read(reuse, (Decoder)wrapped));
    }

    private static <T> SpecificDatumReader<T> buildSpecificReader(Class<T> clazz, Schema schema, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = clazz.getClassLoader();
        }
        SpecificData data = new SpecificData(classLoader);
        if (schema == null && (schema = data.getSchema(clazz)) == null) {
            return null;
        }
        return new SpecificDatumReader(schema, schema, data);
    }

    public static <T extends IndexedRecord> boolean writeToStream(T t, Schema schema, OutputStream out, boolean json) throws NullPointerException, IOException {
        if (t == null) {
            theLogger.error("Unable to write null record to Stream.");
            throw new NullPointerException("Unable to write null record to Stream");
        }
        Object w = t instanceof SpecificRecordBase ? new SpecificDatumWriter(schema) : new GenericDatumWriter(schema);
        EncoderFactory eFact = EncoderFactory.get();
        JsonEncoder e = json ? eFact.jsonEncoder(schema, out) : eFact.binaryEncoder(out, null);
        w.write(t, (Encoder)e);
        e.flush();
        return true;
    }

    public static <T extends IndexedRecord> T readFromFile(Class<T> c, T reuse, Schema schema, File file, boolean json) throws IOException, FileNotFoundException {
        FileInputStream in = new FileInputStream(file);
        return AvroUtils.readFromStream(c, reuse, schema, in, json);
    }

    public static <T extends IndexedRecord> boolean writeToFile(T t, Schema schema, File file, boolean json) throws IOException, FileNotFoundException {
        FileOutputStream out = new FileOutputStream(file);
        return AvroUtils.writeToStream(t, schema, out, json);
    }
}

