/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.extern.utils.xpp3;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.common.config.VersionProperty;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class XMLUtils {
    private static final Logger theLogger = Logger.getLogger(XMLUtils.class.getName());
    public static final String XML_VERSION = "Version";
    public static final String XML_VERSION_TYPE = "type";
    public static final String XML_VERSION_NAME = "Name";
    public static final String XML_VERSION_NUMBER = "Number";
    public static final String VERSION_NAMESPACE = null;

    public static void skipElement(XmlPullParser xpp) throws XmlPullParserException, IOException {
        String name = xpp.getName();
        theLogger.log(Level.FINE, "Skipping Element: {0}", name);
        int eventType = xpp.next();
        while (eventType != 1) {
            if (eventType == 3 && xpp.getName().equals(name)) {
                return;
            }
            if (eventType == 2) {
                XMLUtils.skipElement(xpp);
            }
            eventType = xpp.next();
        }
    }

    public static String getElementText(XmlPullParser xpp) throws XmlPullParserException, IOException {
        String name = xpp.getName();
        int eventType = xpp.getEventType();
        String val = null;
        while (eventType != 1) {
            if (eventType == 4) {
                val = xpp.getText();
            } else if (eventType == 3) {
                if (val == null) break;
                return val;
            }
            eventType = xpp.next();
        }
        throw new IllegalArgumentException("Unable to find value for " + name);
    }

    public static XmlSerializer getXmlFileSerializer(String path) throws XmlPullParserException, FileNotFoundException, IOException {
        XmlPullParserFactory fact = XmlPullParserFactory.newInstance();
        XmlSerializer xs = fact.newSerializer();
        XMLUtils.format(xs, true);
        xs.setOutput((Writer)new FileWriter(path));
        return xs;
    }

    public static void writeVal(XmlSerializer xs, String namespace, String name, Object val) throws IOException {
        xs.startTag(namespace, name);
        xs.text("" + val);
        xs.endTag(namespace, name);
    }

    public static void setIndent(XmlSerializer xs, String indent) {
        xs.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)indent);
    }

    public static void setNewLine(XmlSerializer xs, String nl) {
        xs.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)nl);
    }

    public static void format(XmlSerializer xs, boolean on) {
        XMLUtils.setIndent(xs, on ? "\t" : "");
        XMLUtils.setNewLine(xs, on ? "\n" : "");
    }

    public static void writeVersionProperty(XmlSerializer xs, VersionProperty p, String type) throws IOException {
        String namespace = VERSION_NAMESPACE;
        xs.startTag(namespace, XML_VERSION);
        xs.attribute(namespace, XML_VERSION_TYPE, type);
        xs.startTag(namespace, XML_VERSION_NAME);
        xs.text(p.getName());
        xs.endTag(namespace, XML_VERSION_NAME);
        xs.startTag(namespace, XML_VERSION_NUMBER);
        xs.text(p.getNumber());
        xs.endTag(namespace, XML_VERSION_NUMBER);
        xs.endTag(namespace, XML_VERSION);
    }
}

