/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.headless.animation;

import java.util.logging.Logger;
import javax.jms.Connection;
import org.jflux.api.core.Adapter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.animation.library.AnimationLibrary;
import org.robokind.api.animation.library.DefaultAnimationLibrary;
import org.robokind.api.animation.lifecycle.AnimationPlayerHostLifecycle;
import org.robokind.api.animation.protocol.AnimationEvent;
import org.robokind.api.animation.protocol.AnimationSignal;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.osgi.lifecycle.OSGiComponent;
import org.robokind.impl.animation.messaging.AnimationEventRecord;
import org.robokind.impl.animation.messaging.AnimationSignallingRecord;
import org.robokind.impl.animation.messaging.PortableAnimationEvent;
import org.robokind.impl.animation.messaging.PortableAnimationSignal;
import org.robokind.impl.messaging.lifecycle.JMSAvroAsyncReceiverLifecycle;
import org.robokind.impl.messaging.lifecycle.JMSAvroMessageSenderLifecycle;
import org.robokind.impl.messaging.utils.ConnectionManager;
import org.robokind.impl.messaging.utils.ConnectionUtils;

public class Activator
implements BundleActivator {
    private static final Logger theLogger = Logger.getLogger(Activator.class.getName());
    public static final String PLAYER_ID = "myRobot";
    public static final String ANIM_RECEIVER_ID = "animationReceiver";
    public static final String CONNECTION_ID = "animationConnection";
    public static final String ANIM_DEST_ID = "animationRequest";
    public static final String SIGNAL_DEST_ID = "animationSignal";
    public static final String LIBRARY_ID = "myRobot";
    public static final String SIGNAL_SENDER_ID = "signalSender";

    public void start(BundleContext context) throws Exception {
        this.connectAnimation(context);
        this.launchRemotePlayer(context, "myRobot", ANIM_RECEIVER_ID, SIGNAL_SENDER_ID, CONNECTION_ID, ANIM_DEST_ID);
        new OSGiComponent(context, (ServiceLifecycleProvider)new AnimationPlayerHostLifecycle("Avatar_ZenoR50", ANIM_RECEIVER_ID, SIGNAL_SENDER_ID)).start();
        this.launchAnimationLibrary(context, "myRobot");
    }

    private void connectAnimation(BundleContext context) throws Exception {
        Connection con = ConnectionManager.createConnection((String)"admin", (String)"admin", (String)"client1", (String)"test", (String)"tcp://127.0.0.1:5672");
        con.start();
        theLogger.info("Registering Animation Connection and Destinations");
        ConnectionUtils.ensureSession((BundleContext)context, (String)CONNECTION_ID, (Connection)con, null);
        ConnectionUtils.ensureDestinations((BundleContext)context, (Object[])new Object[]{ANIM_DEST_ID, ANIM_DEST_ID, 1, null});
        ConnectionUtils.ensureDestinations((BundleContext)context, (Object[])new Object[]{SIGNAL_DEST_ID, SIGNAL_DEST_ID, 1, null});
        theLogger.info("Animation Connection and Destinations Registered");
    }

    private void launchRemotePlayer(BundleContext context, String playerId, String receiverId, String senderId, String conId, String destId) {
        JMSAvroMessageSenderLifecycle signalLife = new JMSAvroMessageSenderLifecycle((Adapter)new PortableAnimationSignal.MessageRecordAdapter(), AnimationSignal.class, AnimationSignallingRecord.class, senderId, CONNECTION_ID, SIGNAL_DEST_ID);
        OSGiComponent myAnimationSenderService = new OSGiComponent(context, (ServiceLifecycleProvider)signalLife);
        myAnimationSenderService.start();
        theLogger.info("Launching Dynamic RemoteAnimationPlayerHost Service.");
        new OSGiComponent(context, (ServiceLifecycleProvider)new AnimationPlayerHostLifecycle(playerId, receiverId, senderId)).start();
        JMSAvroAsyncReceiverLifecycle reqRecLifecycle = new JMSAvroAsyncReceiverLifecycle((Adapter)new PortableAnimationEvent.RecordMessageAdapter(), AnimationEvent.class, AnimationEventRecord.class, AnimationEventRecord.SCHEMA$, ANIM_RECEIVER_ID, conId, destId);
        OSGiComponent reqRec = new OSGiComponent(context, (ServiceLifecycleProvider)reqRecLifecycle);
        reqRec.start();
        theLogger.info("Dynamic RemoteAnimationPlayerHost Service Launched.");
    }

    private void launchAnimationLibrary(BundleContext context, String libraryId) {
        theLogger.info("Launching AnimationLibrary Service.");
        DefaultAnimationLibrary library = new DefaultAnimationLibrary(libraryId);
        ServiceRegistration reg = OSGiUtils.registerService((BundleContext)context, (String)AnimationLibrary.class.getName(), (String)"animationPlayerId", (String)libraryId, (Object)library, null);
        theLogger.info("AnimationLibrary Service Launched.");
    }

    public void stop(BundleContext context) throws Exception {
    }
}

