/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.headless.messaging;

import java.util.logging.Logger;
import javax.jms.Connection;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.SimpleLifecycle;
import org.robokind.api.common.osgi.lifecycle.OSGiComponent;
import org.robokind.api.messaging.services.ServiceCommandFactory;
import org.robokind.impl.messaging.services.PortableServiceCommand;
import org.robokind.impl.messaging.utils.ConnectionManager;
import org.robokind.impl.messaging.utils.ConnectionUtils;

public class Activator
implements BundleActivator {
    private static final Logger theLogger = Logger.getLogger(Activator.class.getName());

    public void start(BundleContext context) throws Exception {
        this.connectSpeech(context);
        this.connectAnimation(context);
        this.connectVision(context);
        new OSGiComponent(context, (ServiceLifecycleProvider)new SimpleLifecycle((Object)new PortableServiceCommand.Factory(), ServiceCommandFactory.class)).start();
    }

    private void connectMotion(BundleContext context) throws Exception {
        theLogger.info("Registering Motion Connection and Destinations");
        Connection con = ConnectionManager.createConnection((String)"admin", (String)"admin", (String)"client1", (String)"test", (String)"tcp://127.0.0.1:5672");
        con.start();
        ConnectionUtils.ensureSession((BundleContext)context, (String)"motionConnection", (Connection)con, null);
        ConnectionUtils.ensureDestinations((BundleContext)context, (Object[])new Object[]{"robotRequest", "robotRequest", 0, null, "robotResponse", "robotResponse", 0, null, "robotMotionFrame", "robotMotionFrame", 0, null});
        theLogger.info("Motion Connection and Destinations Registered");
    }

    private void connectSpeech(BundleContext context) throws Exception {
        Connection con = ConnectionManager.createConnection((String)"admin", (String)"admin", (String)"client1", (String)"test", (String)"tcp://127.0.0.1:5672");
        con.start();
        theLogger.info("Registering Speech Connection and Destinations");
        ConnectionUtils.ensureSession((BundleContext)context, (String)"speechConnection", (Connection)con, null);
        ConnectionUtils.ensureDestinations((BundleContext)context, (Object[])new Object[]{"speechCommand", "speechCommand", 0, null, "speechConfig", "speechCommand", 0, null, "speechError", "speechError", 1, null, "speechRequest", "speechRequest", 0, null, "speechEvent", "speechEvent", 1, null});
        theLogger.info("Speech Connection and Destinations Registered");
    }

    private void connectAnimation(BundleContext context) throws Exception {
        Connection con = ConnectionManager.createConnection((String)"admin", (String)"admin", (String)"client1", (String)"test", (String)"tcp://127.0.0.1:5672");
        con.start();
        theLogger.info("Registering Animation Connection and Destinations");
        ConnectionUtils.ensureSession((BundleContext)context, (String)"animationConnection", (Connection)con, null);
        ConnectionUtils.ensureDestinations((BundleContext)context, (Object[])new Object[]{"animationRequest", "animationRequest", 0, null});
        theLogger.info("Animation Connection and Destinations Registered");
    }

    private void connectVision(BundleContext context) throws Exception {
        Connection con = ConnectionManager.createConnection((String)"admin", (String)"admin", (String)"client1", (String)"test", (String)"tcp://127.0.0.1:5672");
        con.start();
        theLogger.info("Registering Vision Connection and Destinations");
        ConnectionUtils.ensureSession((BundleContext)context, (String)"visionConnection", (Connection)con, null);
        ConnectionUtils.ensureDestinations((BundleContext)context, (Object[])new Object[]{"visionCameraCommand", "camera0Command", 0, null, "visionCameraError", "camera0Error", 1, null, "visionCameraEvent", "camera0Event", 1, null, "visionProcCommand", "visionproc0Command", 0, null, "visionProcError", "visionproc0Error", 1, null, "visionProcEvent", "visionproc0Event", 1, null});
        theLogger.info("Vision Connection and Destinations Registered");
    }

    public void stop(BundleContext context) throws Exception {
    }
}

