/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.headless.motion;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.jflux.impl.services.rk.lifecycle.ManagedService;
import org.jflux.impl.services.rk.lifecycle.ServiceLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.utils.ManagedServiceFactory;
import org.jflux.impl.services.rk.lifecycle.utils.SimpleLifecycle;
import org.jflux.impl.services.rk.osgi.lifecycle.OSGiComponent;
import org.jflux.impl.services.rk.osgi.lifecycle.OSGiComponentFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.robokind.api.common.osgi.lifecycle.ConfiguredServiceLifecycle;
import org.robokind.api.common.osgi.lifecycle.ConfiguredServiceParams;
import org.robokind.api.motion.Robot;
import org.robokind.api.motion.lifecycle.RobotJointGroupLifecycle;
import org.robokind.api.motion.servos.ServoRobot;
import org.robokind.api.motion.utils.RobotUtils;
import org.robokind.extern.utils.apache_commons_configuration.ConfigUtils;
import org.robokind.impl.messaging.config.RKMessagingConfigUtils;
import org.robokind.impl.motion.config.RobotConfigXMLReader;
import org.robokind.impl.motion.jointgroup.RobotJointGroupConfigXMLReader;
import org.robokind.impl.motion.lifecycle.RemoteRobotHostServiceGroup;

public class Activator
implements BundleActivator {
    private static final Logger theLogger = Logger.getLogger(Activator.class.getName());
    private static final String ROBOT_CONFIG_FILE = "./resources/robot.xml";
    private static final Robot.Id ROBOT_ID = new Robot.Id("myRobot");
    private static final long theDefaultBlenderInterval = 40L;

    public void start(BundleContext context) throws Exception {
        theLogger.info("Connecting to Servo Robot.");
        Activator.startRobot(context, ROBOT_CONFIG_FILE);
        theLogger.info("Connection Successful.");
        String connectionConfigId = "remoteRobotConnectionConfig";
        RKMessagingConfigUtils.registerConnectionConfig((String)connectionConfigId, (String)"127.0.0.1", null, (ManagedServiceFactory)new OSGiComponentFactory(context));
        new RemoteRobotHostServiceGroup(context, ROBOT_ID, "host", "client", connectionConfigId, null).start();
        RobotUtils.startDefaultBlender((BundleContext)context, (Robot.Id)ROBOT_ID, (long)40L);
        Activator.loadJointGroup(ROBOT_ID, context, "./resources/jointgroup.xml");
    }

    private static void startRobot(BundleContext context, String path) {
        theLogger.info("Opening Robot Config File.");
        File file = ConfigUtils.getFileSystemAdapter().openFile(path);
        if (file == null) {
            return;
        }
        ConfiguredServiceParams robotParams = new ConfiguredServiceParams(Robot.class, null, File.class, null, (Object)file, null, ServoRobot.VERSION, RobotConfigXMLReader.VERSION);
        Properties props = new Properties();
        props.put("robotId", ROBOT_ID);
        ConfiguredServiceLifecycle<Robot, Object, File> robotLifecycle = new ConfiguredServiceLifecycle<Robot, Object, File>(robotParams){

            protected Robot create(Map dependencies) {
                Robot robot = (Robot)super.create(dependencies);
                if (robot == null) {
                    return null;
                }
                robot.connect();
                return robot;
            }
        };
        OSGiComponent robotComp = new OSGiComponent(context, (ServiceLifecycleProvider)robotLifecycle, null, props, true);
        robotComp.start();
    }

    protected static ManagedService loadJointGroup(Robot.Id robotId, BundleContext context, String path) {
        File file = ConfigUtils.getFileSystemAdapter().openFile(path);
        if (file == null) {
            return null;
        }
        String paramId = "robot/" + robotId + "/jointgroup/config/param/xml";
        Activator.launchJointGroupConfig(context, file, paramId);
        return Activator.launchJointGroupLifecycle(context, robotId, paramId);
    }

    protected static OSGiComponent launchJointGroupLifecycle(BundleContext context, Robot.Id robotId, String paramId) {
        RobotJointGroupLifecycle lifecycle = new RobotJointGroupLifecycle(robotId, File.class, paramId, RobotJointGroupConfigXMLReader.VERSION);
        OSGiComponent jointGroupComp = new OSGiComponent(context, (ServiceLifecycleProvider)lifecycle);
        jointGroupComp.start();
        return null;
    }

    protected static OSGiComponent launchJointGroupConfig(BundleContext context, File jointGroupConfigXML, String configFileId) {
        Properties props = new Properties();
        props.put("configParamId", configFileId);
        props.put("configFormatVersion", RobotJointGroupConfigXMLReader.VERSION.toString());
        SimpleLifecycle lifecycle = new SimpleLifecycle((Object)jointGroupConfigXML, File.class, props);
        OSGiComponent paramComp = new OSGiComponent(context, (ServiceLifecycleProvider)lifecycle);
        paramComp.start();
        return paramComp;
    }

    public void stop(BundleContext context) throws Exception {
    }
}

