/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.headless.speech;

import java.util.Properties;
import java.util.logging.Logger;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.util.EmptyAdapter;
import org.jflux.impl.messaging.rk.lifecycle.JMSAvroAsyncReceiverLifecycle;
import org.jflux.impl.messaging.rk.lifecycle.JMSAvroMessageSenderLifecycle;
import org.jflux.impl.services.rk.lifecycle.ServiceLifecycleProvider;
import org.jflux.impl.services.rk.lifecycle.utils.SimpleLifecycle;
import org.jflux.impl.services.rk.osgi.lifecycle.OSGiComponent;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.robokind.api.messaging.services.ServiceCommand;
import org.robokind.api.messaging.services.ServiceError;
import org.robokind.api.speech.SpeechConfig;
import org.robokind.api.speech.SpeechEventList;
import org.robokind.api.speech.SpeechRequest;
import org.robokind.api.speech.SpeechRequestFactory;
import org.robokind.api.speech.lifecycle.RemoteSpeechServiceClientLifecycle;
import org.robokind.api.speech.viseme.lifecycle.VisemeEventNotifierLifecycle;
import org.robokind.impl.messaging.ServiceCommandRecord;
import org.robokind.impl.messaging.ServiceErrorRecord;
import org.robokind.impl.speech.PortableSpeechRequest;
import org.robokind.impl.speech.SpeechConfigRecord;
import org.robokind.impl.speech.SpeechEventListRecord;
import org.robokind.impl.speech.SpeechRequestRecord;

public class Activator
implements BundleActivator {
    private static final Logger theLogger = Logger.getLogger(Activator.class.getName());
    private static final String SPEECH_SERVICE_ID = "speechService";
    private static final String CONNECTION_ID = "speechConnection";
    private static final String COMMAND_DEST_ID = "speechCommand";
    private static final String CONFIG_DEST_ID = "speechConfig";
    private static final String ERROR_DEST_ID = "speechError";
    private static final String REQUEST_DEST_ID = "speechRequest";
    private static final String EVENT_DEST_ID = "speechEvent";
    private static final String COMMAND_SENDER_ID = "speechCommand";
    private static final String CONFIG_SENDER_ID = "speechConfig";
    private static final String ERROR_RECEIVER_ID = "speechError";
    private static final String REQUEST_SENDER_ID = "speechRequest";
    private static final String EVENT_RECEIVER_ID = "speechEvent";

    public void start(BundleContext context) throws Exception {
        theLogger.info("Launching JMS SpeechService Provider.");
        this.launchVisemeNotifier(context, SPEECH_SERVICE_ID);
        this.launchRemoteClient(context, SPEECH_SERVICE_ID, SPEECH_SERVICE_ID, CONNECTION_ID, "speechCommand", "speechCommand", "speechConfig", "speechConfig", "speechError", "speechError", "speechRequest", "speechRequest", "speechEvent", "speechEvent");
        new OSGiComponent(context, (ServiceLifecycleProvider)new SimpleLifecycle((Object)new PortableSpeechRequest.Factory(), SpeechRequestFactory.class)).start();
    }

    private void launchVisemeNotifier(BundleContext context, String speechServiceId) {
        theLogger.info("Launching Dynamic VisemeNotifier Service.");
        new OSGiComponent(context, (ServiceLifecycleProvider)new VisemeEventNotifierLifecycle(speechServiceId)).start();
        theLogger.info("Dynamic VisemeNotifier Service Launched.");
    }

    private void launchRemoteClient(BundleContext context, String speechClientId, String speechHostId, String connectionId, String commandDestId, String commandSenderId, String configDestId, String configSenderId, String errorDestId, String errorReceiverId, String speechReqDestId, String speechRequestSenderId, String speechEventsDestId, String speechEventsReceiverId) {
        Properties props = new Properties();
        props.put("speechServiceId", speechClientId);
        Activator.startClientMessengers(context, props, connectionId, commandDestId, commandSenderId, configDestId, configSenderId, new EmptyAdapter(), SpeechConfig.class, SpeechConfigRecord.class, errorDestId, errorReceiverId);
        Activator.startSpeechMessengers(context, props, connectionId, speechReqDestId, speechRequestSenderId, speechEventsDestId, speechEventsReceiverId);
        this.launchRemoteSpeechClient(context, speechClientId, speechHostId, commandSenderId, configSenderId, errorReceiverId, speechRequestSenderId, speechEventsReceiverId);
    }

    private void launchRemoteSpeechClient(BundleContext context, String speechClientId, String speechHostId, String commandSenderId, String configSenderId, String errorReceiverId, String speechRequestSenderId, String speechEventsReceiverId) {
        RemoteSpeechServiceClientLifecycle lifecycle = new RemoteSpeechServiceClientLifecycle(speechClientId, speechHostId, commandSenderId, configSenderId, errorReceiverId, speechRequestSenderId, speechEventsReceiverId);
        OSGiComponent speechComp = new OSGiComponent(context, (ServiceLifecycleProvider)lifecycle);
        speechComp.start();
    }

    private static <Msg, Rec> void startClientMessengers(BundleContext context, Properties groupProps, String connectionId, String commandDestId, String commandSenderId, String configDestId, String configSenderId, Adapter<Msg, Rec> configMsgRecAdapter, Class<Msg> msgClass, Class<Rec> recClass, String errorDestId, String errorReceiverId) {
        JMSAvroMessageSenderLifecycle commandSender = new JMSAvroMessageSenderLifecycle((Adapter)new EmptyAdapter(), ServiceCommand.class, ServiceCommandRecord.class, commandSenderId, connectionId, commandDestId);
        new OSGiComponent(context, (ServiceLifecycleProvider)commandSender, groupProps).start();
        JMSAvroMessageSenderLifecycle configSender = new JMSAvroMessageSenderLifecycle(configMsgRecAdapter, msgClass, recClass, configSenderId, connectionId, configDestId);
        new OSGiComponent(context, (ServiceLifecycleProvider)configSender, groupProps).start();
        JMSAvroAsyncReceiverLifecycle errorReceiver = new JMSAvroAsyncReceiverLifecycle((Adapter)new EmptyAdapter(), ServiceError.class, ServiceErrorRecord.class, ServiceErrorRecord.SCHEMA$, errorReceiverId, connectionId, errorDestId);
        new OSGiComponent(context, (ServiceLifecycleProvider)errorReceiver, groupProps).start();
    }

    private static void startSpeechMessengers(BundleContext context, Properties groupProps, String connectionId, String speechReqDestId, String speechRequestSenderId, String speechEventsDestId, String speechEventsReceiverId) {
        JMSAvroMessageSenderLifecycle speechRequestSender = new JMSAvroMessageSenderLifecycle((Adapter)new EmptyAdapter(), SpeechRequest.class, SpeechRequestRecord.class, speechRequestSenderId, connectionId, speechReqDestId);
        new OSGiComponent(context, (ServiceLifecycleProvider)speechRequestSender, groupProps).start();
        JMSAvroAsyncReceiverLifecycle speechEventsReceiver = new JMSAvroAsyncReceiverLifecycle((Adapter)new EmptyAdapter(), SpeechEventList.class, SpeechEventListRecord.class, SpeechEventListRecord.SCHEMA$, speechEventsReceiverId, connectionId, speechEventsDestId);
        new OSGiComponent(context, (ServiceLifecycleProvider)speechEventsReceiver, groupProps).start();
    }

    public void stop(BundleContext context) throws Exception {
    }
}

