/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.animation.messaging;

import java.util.Collections;
import java.util.List;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.player.AnimationJob;
import org.robokind.api.animation.player.AnimationPlayer;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class JMSAnimationPlayerProxy implements AnimationPlayer{
    private String myAnimationPlayerId;
    private JMSAnimationSender myAnimationSender;

    public JMSAnimationPlayerProxy(String playerId){
        if(playerId == null){
            throw new NullPointerException();
        }
        myAnimationPlayerId = playerId;
    }
    
    @Override
    public String getAnimationPlayerId(){
        return myAnimationPlayerId;
    }
    
    @Override
    public AnimationJob playAnimation(Animation animation) {
        myAnimationSender.sendAnimation(animation);
        return null;
    }

    @Override
    public AnimationJob playAnimation(Animation animation, Long start, Long stop) {
        animation.setStartTime(start);
        animation.setStopTime(stop);
        myAnimationSender.sendAnimation(animation);
        return null;
    }

    @Override
    public List<AnimationJob> getCurrentAnimations() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void removeAnimationJob(AnimationJob job) {}
    
}
