/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.animation.messaging;

import javax.jms.Destination;
import javax.jms.Session;
import org.robokind.api.animation.protocol.AnimationEvent;
import org.robokind.api.common.utils.Adapter;
import org.robokind.api.common.utils.Listener;
import org.robokind.avrogen.animation.AnimationEventRecord;
import org.robokind.impl.messaging.JMSAvroMessageAsyncReceiver;

/**
 * JMSAvroMessageAsyncReceiver for receiving AnimationEvents.
 * @author Matthew Stevenson <www.robokind.org>
 */
public class JMSAnimationReceiver extends JMSAvroMessageAsyncReceiver<
        AnimationEvent, AnimationEventRecord, Listener<AnimationEvent>> {
    /**
     * Creates a new JMSAnimationReceiver.
     * @param sessionJMS Session to use
     * @param destination JMS Destination to use
     */
    public JMSAnimationReceiver(Session session, Destination destination){
        super(session, destination,
                AnimationEventRecord.class, AnimationEventRecord.SCHEMA$);
        setAdapter(new AnimationEventRecordAdapter());
    }
    /**
     * Converts an AnimationEventRecord to an AnimationEvent.
     */
    public static class AnimationEventRecordAdapter
            implements Adapter<AnimationEventRecord, AnimationEvent>{
        @Override
        public AnimationEvent adapt(AnimationEventRecord a) {
            return new PortableAnimationEvent(a);
        }
    }
}
