/*
 * Copyright 2012 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.animation.messaging;

import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.Session;
import org.robokind.api.animation.messaging.RemoteAnimationPlayerHost;
import org.robokind.api.animation.player.AnimationPlayer;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class JMSRemoteAnimationPlayerHost extends RemoteAnimationPlayerHost {
    private final static Logger theLogger = 
            Logger.getLogger(JMSRemoteAnimationPlayerHost.class.getName());
    
    private Session mySession;
    private Destination myAnimationDestination;
    private JMSAnimationReceiver myJMSAnimReceiver;
    
    public JMSRemoteAnimationPlayerHost(
            Session session, Destination dest, AnimationPlayer player) 
            throws Exception{
        mySession = session;
        myAnimationDestination = dest;
        setAnimationPlayer(player);
        initialize();
    }
    
    private void initialize() throws Exception{
        theLogger.info("Initializing JMSRemoteAnimationPlayerHost");
        JMSAnimationReceiver oldRec = myJMSAnimReceiver;
        if(mySession != null && myAnimationDestination != null){
            theLogger.info("Creating new JMSAnimationReceiver.");
            myJMSAnimReceiver = 
                    new JMSAnimationReceiver(mySession, myAnimationDestination);
            setAnimationReceiver(myJMSAnimReceiver);
            theLogger.info("Starting JMSAnimationReceiver");
            myJMSAnimReceiver.start();
        }else{
            theLogger.info("Cannot initialize: "
                    + "Session or Destination unavailable.  "
                    + "Setting null Animation Receiver.  "
                    + "Set valid Session and Destination to reinitialize.");
            myJMSAnimReceiver = null;
            setAnimationReceiver(null);
        }
        if(oldRec != null){
            theLogger.info("Stopping old JMSAnimationReceiver.");
            oldRec.stop();
        }
    }
    
    public void setSession(Session session) throws Exception{
        if(session == mySession){
            return;
        }
        mySession = session;
        initialize();
    }
    
    public void setDestination(Destination dest) throws Exception{
        if(dest == myAnimationDestination){
            return;
        }
        myAnimationDestination = dest;
        initialize();
    }
    
}
