/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.animation.messaging;

import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.library.AnimationLibrary;
import org.robokind.api.animation.protocol.AnimationEvent;
import org.robokind.api.common.osgi.ClassTracker;
import org.robokind.api.common.utils.Listener;

/**
 *
 * @author Matthew Stevenson <www.robokind.org>
 */
public class LibraryAnimationListener implements Listener<AnimationEvent>{
    private final static Logger theLogger = 
            Logger.getLogger(LibraryAnimationListener.class.getName());
    private BundleContext myContext;
    private ClassTracker<AnimationLibrary> myLibraryTracker;
    
    public LibraryAnimationListener(
            BundleContext context, String libraryFilter){
        if(context == null){
            throw new NullPointerException();
        }
        myContext = context;
        myLibraryTracker = new ClassTracker<AnimationLibrary>(context, 
                AnimationLibrary.class.getName(), libraryFilter);
        myLibraryTracker.init();
    }
    
    public void setLibraryFilter(String filter){
        myLibraryTracker.setFilter(filter);
        myLibraryTracker.init();
    }

    @Override
    public void handleEvent(AnimationEvent event) {
        if(event == null){
            return;
        }
        Animation anim = event.getAnimation();
        if(anim == null){
            return;
        }
        AnimationLibrary lib = myLibraryTracker.getTopService();
        if(lib == null){
            return;
        }
        lib.add(anim);
    }
}
