/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.animation.messaging;

import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.Session;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.protocol.AnimationEvent;
import org.robokind.api.common.utils.Adapter;
import org.robokind.api.common.utils.Listener;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.avrogen.animation.AnimationEventRecord;
import org.robokind.impl.animation.messaging.PortableAnimationEvent;
import org.robokind.impl.messaging.JMSAvroMessageSender;

public class JMSAnimationSender
extends JMSAvroMessageSender<AnimationEvent, AnimationEventRecord, Listener<AnimationEvent>> {
    static final Logger theLogger = Logger.getLogger(JMSAnimationSender.class.getName());
    private String mySourceId;
    private String myDestinationId;

    public JMSAnimationSender(Session session, Destination destination) {
        super(session, destination);
        this.setAdapter(new AnimationEventAdapter());
    }

    public void setSourceId(String sourceId) {
        this.mySourceId = sourceId;
    }

    public void setDestinationId(String destId) {
        this.myDestinationId = destId;
    }

    public void sendAnimation(Animation animation) {
        if (animation == null || this.mySourceId == null || this.myDestinationId == null) {
            throw new NullPointerException();
        }
        PortableAnimationEvent frameEvent = new PortableAnimationEvent(this.mySourceId, this.myDestinationId, TimeUtils.now(), animation);
        super.sendMessage((Object)frameEvent);
    }

    public static class AnimationEventAdapter
    implements Adapter<AnimationEvent, AnimationEventRecord> {
        public AnimationEventRecord adapt(AnimationEvent a) {
            return new PortableAnimationEvent(a).getAnimationEventRecord();
        }
    }
}

