/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.animation.messaging;

import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.library.AnimationLibrary;
import org.robokind.api.animation.protocol.AnimationEvent;
import org.robokind.api.common.osgi.ClassTracker;
import org.robokind.api.common.utils.Listener;

public class LibraryAnimationListener
implements Listener<AnimationEvent> {
    private static final Logger theLogger = Logger.getLogger(LibraryAnimationListener.class.getName());
    private BundleContext myContext;
    private ClassTracker<AnimationLibrary> myLibraryTracker;

    public LibraryAnimationListener(BundleContext context, String libraryFilter) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.myContext = context;
        this.myLibraryTracker = new ClassTracker(context, AnimationLibrary.class.getName(), libraryFilter);
        this.myLibraryTracker.init();
    }

    public void setLibraryFilter(String filter) {
        this.myLibraryTracker.setFilter(filter);
        this.myLibraryTracker.init();
    }

    public void handleEvent(AnimationEvent event) {
        if (event == null) {
            return;
        }
        Animation anim = event.getAnimation();
        if (anim == null) {
            return;
        }
        AnimationLibrary lib = (AnimationLibrary)this.myLibraryTracker.getTopService();
        if (lib == null) {
            return;
        }
        lib.add(anim);
    }
}

