/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.animation.messaging;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.Channel;
import org.robokind.api.animation.MotionPath;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.interpolation.InterpolatorDirectory;
import org.robokind.api.interpolation.InterpolatorFactory;
import org.robokind.avrogen.animation.AnimationRecord;
import org.robokind.avrogen.animation.ChannelRecord;
import org.robokind.avrogen.animation.ControlPointRecord;
import org.robokind.avrogen.animation.InterpolatorTypeRecord;
import org.robokind.avrogen.animation.MotionPathRecord;

public class AnimationMessagingUtils {
    public static AnimationRecord packAnimation(Animation animation) {
        if (animation == null) {
            throw new NullPointerException();
        }
        AnimationRecord animRec = new AnimationRecord();
        animRec.name = new Utf8(animation.getVersion().getName());
        animRec.versionNumber = new Utf8(animation.getVersion().getNumber());
        animRec.startTime = animation.getStartTime();
        animRec.stopTime = animation.getStopTime();
        Schema arraySchema = Schema.createArray((Schema)ChannelRecord.SCHEMA$);
        List chanList = animation.getChannels();
        GenericData.Array channels = new GenericData.Array(chanList.size(), arraySchema);
        for (Channel chan : chanList) {
            channels.add((Object)AnimationMessagingUtils.packChannel(chan));
        }
        animRec.channels = channels;
        return animRec;
    }

    private static ChannelRecord packChannel(Channel channel) {
        ChannelRecord chanRec = new ChannelRecord();
        chanRec.name = new Utf8(channel.getName());
        chanRec.channelId = channel.getId();
        chanRec.startTime = channel.getStartTime();
        chanRec.stopTime = channel.getStopTime();
        Schema arraySchema = Schema.createArray((Schema)MotionPathRecord.SCHEMA$);
        List pathList = channel.getMotionPaths();
        GenericData.Array paths = new GenericData.Array(pathList.size(), arraySchema);
        int i = 0;
        for (MotionPath mp : pathList) {
            paths.add((Object)AnimationMessagingUtils.packMotionPath(mp, i++));
        }
        chanRec.motionPaths = paths;
        return chanRec;
    }

    private static MotionPathRecord packMotionPath(MotionPath path, int id) {
        MotionPathRecord pathRec = new MotionPathRecord();
        pathRec.name = new Utf8(path.getName());
        pathRec.motionPathId = id;
        pathRec.startTime = path.getStartTime();
        pathRec.stopTime = path.getStopTime();
        VersionProperty interpVersion = path.getInterpolatorVersion();
        pathRec.interpolator = AnimationMessagingUtils.packInterpolatorType(interpVersion);
        Schema arraySchema = Schema.createArray((Schema)ControlPointRecord.SCHEMA$);
        List pointList = path.getControlPoints();
        GenericData.Array points = new GenericData.Array(pointList.size(), arraySchema);
        for (Point2D p : pointList) {
            points.add((Object)AnimationMessagingUtils.packControlPoint(p));
        }
        pathRec.controlPoints = points;
        return pathRec;
    }

    private static InterpolatorTypeRecord packInterpolatorType(VersionProperty prop) {
        InterpolatorTypeRecord interp = new InterpolatorTypeRecord();
        interp.name = new Utf8(prop.getName());
        interp.versionNumber = new Utf8(prop.getNumber());
        return interp;
    }

    private static ControlPointRecord packControlPoint(Point2D point) {
        ControlPointRecord pointRec = new ControlPointRecord();
        pointRec.time = (long)point.getX();
        pointRec.position = point.getY();
        return pointRec;
    }

    public static Animation unpackAnimation(AnimationRecord animRec) {
        String name = animRec.name.toString();
        String number = animRec.versionNumber.toString();
        VersionProperty animVersion = new VersionProperty(name, number);
        Animation anim = new Animation(animVersion);
        for (ChannelRecord chanRec : animRec.channels) {
            anim.addChannel(AnimationMessagingUtils.unpackChannel(chanRec));
        }
        if (animRec.startTime != null) {
            anim.setStartTime(animRec.startTime);
        }
        if (animRec.stopTime != null) {
            anim.setStopTime(animRec.stopTime);
        }
        return anim;
    }

    private static Channel unpackChannel(ChannelRecord chanRec) {
        Channel chan = new Channel(chanRec.channelId, chanRec.name.toString());
        for (MotionPathRecord pathRec : chanRec.motionPaths) {
            chan.addPath(AnimationMessagingUtils.unpackMotionPath(pathRec));
        }
        if (chanRec.startTime != null) {
            chan.setStartTime(chanRec.startTime);
        }
        if (chanRec.stopTime != null) {
            chan.setStopTime(chanRec.stopTime);
        }
        return chan;
    }

    private static MotionPath unpackMotionPath(MotionPathRecord pathRec) {
        String interpName = pathRec.interpolator.name.toString();
        String interpNumber = pathRec.interpolator.versionNumber.toString();
        VersionProperty interp = new VersionProperty(interpName, interpNumber);
        InterpolatorFactory fact = InterpolatorDirectory.instance().getFactory(interp);
        MotionPath path = new MotionPath(fact);
        path.setName(pathRec.name.toString());
        int pointCount = pathRec.controlPoints.size();
        ArrayList<Point2D> points = new ArrayList<Point2D>(pointCount);
        for (ControlPointRecord pr : pathRec.controlPoints) {
            points.add(AnimationMessagingUtils.unpackControlPoint(pr));
        }
        path.addPoints(points);
        if (pathRec.startTime != null) {
            path.setStartTime(pathRec.startTime);
        }
        if (pathRec.stopTime != null) {
            path.setStopTime(pathRec.stopTime);
        }
        return path;
    }

    private static Point2D unpackControlPoint(ControlPointRecord pointRec) {
        return new Point2D.Double(pointRec.time, pointRec.position);
    }
}

