/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.animation.messaging;

import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.Session;
import org.robokind.api.animation.messaging.RemoteAnimationPlayerHost;
import org.robokind.api.animation.player.AnimationPlayer;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.impl.animation.messaging.JMSAnimationReceiver;

public class JMSRemoteAnimationPlayerHost
extends RemoteAnimationPlayerHost {
    private static final Logger theLogger = Logger.getLogger(JMSRemoteAnimationPlayerHost.class.getName());
    private Session mySession;
    private Destination myAnimationDestination;
    private JMSAnimationReceiver myJMSAnimReceiver;

    public JMSRemoteAnimationPlayerHost(Session session, Destination dest, AnimationPlayer player) throws Exception {
        this.mySession = session;
        this.myAnimationDestination = dest;
        this.setAnimationPlayer(player);
        this.initialize();
    }

    private void initialize() throws Exception {
        theLogger.info("Initializing JMSRemoteAnimationPlayerHost");
        JMSAnimationReceiver oldRec = this.myJMSAnimReceiver;
        if (this.mySession != null && this.myAnimationDestination != null) {
            theLogger.info("Creating new JMSAnimationReceiver.");
            this.myJMSAnimReceiver = new JMSAnimationReceiver(this.mySession, this.myAnimationDestination);
            this.setAnimationReceiver((MessageAsyncReceiver)this.myJMSAnimReceiver);
            theLogger.info("Starting JMSAnimationReceiver");
            this.myJMSAnimReceiver.start();
        } else {
            theLogger.info("Cannot initialize: Session or Destination unavailable.  Setting null Animation Receiver.  Set valid Session and Destination to reinitialize.");
            this.myJMSAnimReceiver = null;
            this.setAnimationReceiver(null);
        }
        if (oldRec != null) {
            theLogger.info("Stopping old JMSAnimationReceiver.");
            oldRec.stop();
        }
    }

    public void setSession(Session session) throws Exception {
        if (session == this.mySession) {
            return;
        }
        this.mySession = session;
        this.initialize();
    }

    public void setDestination(Destination dest) throws Exception {
        if (dest == this.myAnimationDestination) {
            return;
        }
        this.myAnimationDestination = dest;
        this.initialize();
    }
}

