/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.animation.osgi;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.robokind.api.animation.xml.AnimationFileReader;
import org.robokind.api.animation.xml.AnimationFileWriter;
import org.robokind.api.common.osgi.lifecycle.DynamicServiceLauncher;
import org.robokind.api.common.osgi.lifecycle.ServiceLifecycleProvider;
import org.robokind.impl.animation.osgi.JMSAnimationPlayerLifecycleProvider;
import org.robokind.impl.animation.xml.AnimationXMLReader;
import org.robokind.impl.animation.xml.ApacheAnimationXMLWriter;

public class Activator
implements BundleActivator {
    private static final Logger theLogger = Logger.getLogger(Activator.class.getName());
    public static final String PLAYER_ID = "myRobot";
    public static final String CONNECTION_ID = "animationConnection";
    public static final String ANIM_DEST_ID = "animationRequest";

    public void start(BundleContext context) throws Exception {
        theLogger.log(Level.INFO, "AnimationImpl Activation Begin.");
        this.registerAnimationReader(context);
        this.registerAnimationWriter(context);
        this.launchRemotePlayer(context, PLAYER_ID, CONNECTION_ID, ANIM_DEST_ID);
        theLogger.log(Level.INFO, "AnimationImpl Activation Complete.");
    }

    private void registerAnimationReader(BundleContext context) {
        context.registerService(AnimationFileReader.class.getName(), (Object)new AnimationXMLReader(), null);
        theLogger.log(Level.INFO, "AnimationXMLReader Service Registered Successfully.");
    }

    private void registerAnimationWriter(BundleContext context) {
        context.registerService(AnimationFileWriter.class.getName(), (Object)new ApacheAnimationXMLWriter(), null);
        theLogger.log(Level.INFO, "ApacheAnimationXMLWriter Service Registered Successfully.");
    }

    private void launchRemotePlayer(BundleContext context, String playerId, String conId, String destId) {
        theLogger.info("Launching Dynamic RemoteAnimationPlayerHost Service.");
        new DynamicServiceLauncher(context, (ServiceLifecycleProvider)new JMSAnimationPlayerLifecycleProvider(playerId, conId, destId)).start();
        theLogger.info("Dynamic RemoteAnimationPlayerHost Service Launched.");
    }

    public void stop(BundleContext context) throws Exception {
    }
}

