/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.animation.osgi;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.robokind.api.animation.messaging.RemoteAnimationPlayerHost;
import org.robokind.api.animation.player.AnimationPlayer;
import org.robokind.api.common.osgi.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.osgi.lifecycle.DescriptorListBuilder;
import org.robokind.impl.animation.messaging.JMSRemoteAnimationPlayerHost;

public class JMSAnimationPlayerLifecycleProvider
extends AbstractLifecycleProvider<RemoteAnimationPlayerHost, JMSRemoteAnimationPlayerHost> {
    private static final Logger theLogger = Logger.getLogger(JMSAnimationPlayerLifecycleProvider.class.getName());
    private static final String theDepPlayerId = "animPlayer";
    private static final String theDepConnectionId = "animConnection";
    private static final String theDepAnimationDestId = "animDestination";
    private Session mySession;

    public JMSAnimationPlayerLifecycleProvider(String animPlayerId, String connId, String animDestId) {
        super(new DescriptorListBuilder().addId(theDepPlayerId, AnimationPlayer.class, "animationPlayerId", animPlayerId).addId(theDepConnectionId, Connection.class, "connectionId", connId).addId(theDepAnimationDestId, Destination.class, "destinationId", animDestId).getDescriptors());
    }

    protected JMSRemoteAnimationPlayerHost create(Map<String, Object> services) {
        AnimationPlayer player = (AnimationPlayer)services.get(theDepPlayerId);
        Connection con = (Connection)services.get(theDepConnectionId);
        Destination dest = (Destination)services.get(theDepAnimationDestId);
        this.setSession(con);
        try {
            return new JMSRemoteAnimationPlayerHost(this.mySession, dest, player);
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "There was an error creating and starting the RemoteAnimationPlayerHost.", ex);
            return null;
        }
    }

    private void setSession(Connection con) {
        Session oldSession = this.mySession;
        try {
            this.mySession = con.createSession(false, 2);
        }
        catch (JMSException ex) {
            theLogger.log(Level.WARNING, "Unable to create Session.", ex);
            this.mySession = null;
        }
        if (this.myService != null) {
            try {
                ((JMSRemoteAnimationPlayerHost)((Object)this.myService)).setSession(this.mySession);
            }
            catch (Exception ex) {
                theLogger.log(Level.WARNING, "There was an error setting the Session.", ex);
            }
        }
        if (oldSession != null) {
            try {
                oldSession.close();
            }
            catch (Exception ex) {
                theLogger.log(Level.WARNING, "There was an error closing the old Session.", ex);
            }
        }
    }

    protected void handleChange(String serviceId, Object service) {
        if (theDepPlayerId.equals(serviceId)) {
            ((JMSRemoteAnimationPlayerHost)((Object)this.myService)).setAnimationPlayer((AnimationPlayer)service);
        } else if (theDepConnectionId.equals(serviceId)) {
            this.setSession((Connection)service);
        } else if (theDepAnimationDestId.equals(serviceId)) {
            try {
                ((JMSRemoteAnimationPlayerHost)((Object)this.myService)).setDestination((Destination)service);
            }
            catch (Exception ex) {
                theLogger.log(Level.WARNING, "There was an error setting the new Destination.", ex);
            }
        }
    }

    public Class<RemoteAnimationPlayerHost> getServiceClass() {
        return RemoteAnimationPlayerHost.class;
    }
}

