/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.animation.xml;

import java.awt.geom.Point2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.Channel;
import org.robokind.api.animation.MotionPath;
import org.robokind.api.animation.xml.AnimationFileWriter;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.playable.Playable;
import org.robokind.api.common.services.addon.AddOnUtils;
import org.robokind.api.common.services.addon.ServiceAddOn;
import org.robokind.api.common.services.addon.ServiceAddOnDriver;
import org.robokind.extern.utils.xpp3.XMLUtils;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XPP3AnimationXMLWriter
implements AnimationFileWriter {
    private static final Logger theLogger = Logger.getLogger(XPP3AnimationXMLWriter.class.getName());
    private static String namespace = null;

    public void writeAnimation(String path, Animation anim) throws Exception {
        XPP3AnimationXMLWriter.saveAnimation(path, anim);
    }

    static void saveAnimation(String file, Animation a) throws XmlPullParserException, IOException, IllegalArgumentException, FileNotFoundException {
        XmlSerializer xs = XMLUtils.getXmlFileSerializer((String)file);
        xs.startDocument(null, null);
        xs.text("\n");
        XPP3AnimationXMLWriter.writeAnimation(xs, a, file);
        xs.endDocument();
        xs.flush();
    }

    public static void writeAnimation(XmlSerializer xs, Animation a, String file) throws IOException {
        xs.startTag(namespace, "Animation");
        XMLUtils.writeVersionProperty((XmlSerializer)xs, (VersionProperty)a.getVersion(), (String)"Animation");
        xs.startTag(namespace, "Channels");
        for (Channel channel : a.getChannels()) {
            XPP3AnimationXMLWriter.writeChannel(xs, channel);
        }
        xs.endTag(namespace, "Channels");
        XPP3AnimationXMLWriter.writeAddOnList(xs, a.getAddOns(), file);
        xs.endTag(namespace, "Animation");
    }

    public static void writeChannel(XmlSerializer xs, Channel channel) throws IOException {
        xs.startTag(namespace, "Channel");
        xs.attribute(namespace, "id", channel.getId().toString());
        String name = channel.getName();
        if (name != null && !name.isEmpty()) {
            xs.attribute(namespace, "name", name);
        }
        xs.startTag(namespace, "MotionPaths");
        for (MotionPath mp : channel.getMotionPaths()) {
            XPP3AnimationXMLWriter.writeMotionPath(xs, mp);
        }
        xs.endTag(namespace, "MotionPaths");
        xs.endTag(namespace, "Channel");
    }

    public static void writeMotionPath(XmlSerializer xs, MotionPath mp) throws IOException {
        xs.startTag(namespace, "MotionPath");
        String name = mp.getName();
        if (name != null && !name.isEmpty()) {
            xs.attribute(namespace, "name", name);
        }
        XMLUtils.writeVersionProperty((XmlSerializer)xs, (VersionProperty)mp.getInterpolatorVersion(), (String)"Interpolation");
        XPP3AnimationXMLWriter.writeControlPoints(xs, mp.getControlPoints());
        xs.endTag(namespace, "MotionPath");
    }

    public static void writeControlPoints(XmlSerializer xs, List<Point2D> points) throws IOException {
        xs.startTag(namespace, "ControlPoints");
        for (Point2D p : points) {
            XPP3AnimationXMLWriter.writeControlPoint(xs, p);
        }
        xs.endTag(namespace, "ControlPoints");
    }

    public static void writeControlPoint(XmlSerializer xs, Point2D p) throws IOException {
        xs.startTag(namespace, "ControlPoint");
        XMLUtils.format((XmlSerializer)xs, (boolean)false);
        xs.startTag(namespace, "Time");
        xs.text(Double.valueOf(p.getX()).toString());
        xs.endTag(namespace, "Time");
        xs.startTag(namespace, "Position");
        xs.text(Double.valueOf(p.getY()).toString());
        xs.endTag(namespace, "Position");
        XMLUtils.format((XmlSerializer)xs, (boolean)true);
        xs.endTag(namespace, "ControlPoint");
    }

    public static void writeAddOnList(XmlSerializer xs, List<ServiceAddOn<Playable>> addons, String animPath) throws IOException {
        if (addons == null || animPath == null) {
            throw new NullPointerException();
        }
        xs.startTag(namespace, "AddOns");
        int addonCount = 0;
        for (ServiceAddOn<Playable> addon : addons) {
            String addonPath = animPath + ".addon." + addonCount + ".conf";
            try {
                XPP3AnimationXMLWriter.writeAddOn(xs, addon, addonPath);
            }
            catch (Exception ex) {
                theLogger.log(Level.WARNING, "Error writing AddOn.", ex);
                continue;
            }
            ++addonCount;
        }
        xs.endTag(namespace, "AddOns");
    }

    public static void writeAddOn(XmlSerializer xs, ServiceAddOn<Playable> addon, String addonPath) throws Exception {
        if (addon == null || addonPath == null) {
            return;
        }
        ServiceAddOnDriver driver = addon.getAddOnDriver();
        if (driver == null) {
            throw new NullPointerException();
        }
        if (!AddOnUtils.saveAddOnConfig(addon, (String)addonPath)) {
            return;
        }
        xs.startTag(namespace, "AddOn");
        XMLUtils.writeVersionProperty((XmlSerializer)xs, (VersionProperty)driver.getServiceVersion(), (String)"ServiceVersion");
        XMLUtils.writeVersionProperty((XmlSerializer)xs, (VersionProperty)driver.getConfigurationFormat(), (String)"ConfigurationFormatVersion");
        xs.startTag(namespace, "AddOnFile");
        xs.text(addonPath);
        xs.endTag(namespace, "AddOnFile");
        xs.endTag(namespace, "AddOn");
    }
}

