/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.robokind.impl.animation.osgi;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.robokind.api.animation.xml.AnimationFileReader;
import org.robokind.api.animation.xml.AnimationFileWriter;
import org.robokind.impl.animation.xml.AnimationXMLReader;
import org.robokind.impl.animation.xml.XPP3AnimationXMLWriter;

/**
 * 
 * @author Matthew Stevenson <www.robokind.org>
 */
public class Activator implements BundleActivator {
    private final static Logger theLogger = 
            Logger.getLogger(Activator.class.getName());

    @Override
    public void start(BundleContext context) throws Exception {
        theLogger.log(Level.INFO, "AnimationImpl Activation Begin.");
        registerAnimationReader(context);
        registerAnimationWriter(context);
        theLogger.log(Level.INFO, "AnimationImpl Activation Complete.");
    }
    
    private void registerAnimationReader(BundleContext context){
        context.registerService(AnimationFileReader.class.getName(), 
                new AnimationXMLReader(), null);
        theLogger.log(Level.INFO, 
                "AnimationXMLReader Service Registered Successfully.");
    }
    
    private void registerAnimationWriter(BundleContext context){
        context.registerService(AnimationFileWriter.class.getName(), 
                new XPP3AnimationXMLWriter(), null);
        theLogger.log(Level.INFO, 
                "XPP3AnimationXMLWriter Service Registered Successfully.");
    }

    @Override
    public void stop(BundleContext context) throws Exception {
    }

}
