/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.animation.messaging;

import org.apache.avro.util.Utf8;
import org.jflux.api.core.util.Adapter;
import org.robokind.api.animation.protocol.PlayRequest;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.avrogen.animation.PlayRequestRecord;

public class PortablePlayRequest
implements PlayRequest {
    private PlayRequestRecord myPlayRquestRecord;

    public PortablePlayRequest(PlayRequestRecord playRec) {
        if (playRec == null) {
            throw new NullPointerException();
        }
        this.myPlayRquestRecord = playRec;
    }

    public PortablePlayRequest(PlayRequest playRequest) {
        PlayRequestRecord rec = new PlayRequestRecord();
        rec.sourceId = new Utf8(playRequest.getSourceId());
        rec.destinationId = new Utf8(playRequest.getDestinationId());
        rec.currentTimeMillisec = playRequest.getTimestampMillisecUTC();
        rec.animationName = new Utf8(playRequest.getAnimationName());
        rec.animationVersionNumber = new Utf8(playRequest.getAnimationVersionNumber());
        this.myPlayRquestRecord = rec;
    }

    public PortablePlayRequest(String sourceId, String destId, long curTimeMillisecUTC, String animName, String animVersionNum) {
        PlayRequestRecord rec = new PlayRequestRecord();
        rec.sourceId = new Utf8(sourceId);
        rec.destinationId = new Utf8(destId);
        rec.currentTimeMillisec = curTimeMillisecUTC;
        rec.animationName = new Utf8(animName);
        rec.animationVersionNumber = new Utf8(animVersionNum);
        this.myPlayRquestRecord = rec;
    }

    public String getSourceId() {
        return this.myPlayRquestRecord.sourceId.toString();
    }

    public String getDestinationId() {
        return this.myPlayRquestRecord.destinationId.toString();
    }

    public long getTimestampMillisecUTC() {
        return this.myPlayRquestRecord.currentTimeMillisec;
    }

    public String getAnimationName() {
        return this.myPlayRquestRecord.animationName.toString();
    }

    public String getAnimationVersionNumber() {
        if (this.myPlayRquestRecord.animationVersionNumber == null) {
            return null;
        }
        return this.myPlayRquestRecord.animationVersionNumber.toString();
    }

    public PlayRequestRecord getRecord() {
        return this.myPlayRquestRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<PlayRequestRecord, PlayRequest> {
        public PlayRequest adapt(PlayRequestRecord a) {
            return new PortablePlayRequest(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<PlayRequest, PlayRequestRecord> {
        public PlayRequestRecord adapt(PlayRequest a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortablePlayRequest(a).getRecord();
        }
    }

    public static class Factory
    implements PlayRequest.PlayRequestFactory {
        public PlayRequest createPlayRequest(String clientId, String hostId, VersionProperty animVersion) {
            if (clientId == null || hostId == null || animVersion == null) {
                throw new NullPointerException();
            }
            return new PortablePlayRequest(clientId, hostId, TimeUtils.now(), animVersion.getName(), animVersion.getNumber());
        }
    }
}

