/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.animation.xml;

import java.awt.geom.Point2D;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.Channel;
import org.robokind.api.animation.MotionPath;
import org.robokind.api.animation.editor.features.SynchronizedPointGroup;
import org.robokind.api.animation.utils.ChannelsParameter;
import org.robokind.api.animation.utils.ChannelsParameterSource;
import org.robokind.api.animation.xml.AnimationFileWriter;
import org.robokind.api.animation.xml.AnimationXML;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.playable.Playable;
import org.robokind.api.common.position.NormalizableRange;
import org.robokind.api.common.services.addon.AddOnUtils;
import org.robokind.api.common.services.addon.ServiceAddOn;
import org.robokind.api.common.services.addon.ServiceAddOnDriver;
import org.robokind.extern.utils.xpp3.XMLUtils;
import org.robokind.impl.animation.xml.SyncPointGroupXML;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XPP3AnimationXMLWriter
implements AnimationFileWriter {
    private static final Logger theLogger = Logger.getLogger(XPP3AnimationXMLWriter.class.getName());

    public void writeAnimation(String path, Animation anim, ChannelsParameterSource source, Set<SynchronizedPointGroup> syncPointGroups) throws Exception {
        XPP3AnimationXMLWriter.saveAnimation(path, anim, source, syncPointGroups);
    }

    static void saveAnimation(String file, Animation a, ChannelsParameterSource source, Set<SynchronizedPointGroup> syncPointGroups) throws XmlPullParserException, IOException, IllegalArgumentException, FileNotFoundException {
        XmlSerializer xs = XMLUtils.getXmlFileSerializer((String)file);
        xs.startDocument(null, null);
        xs.text("\n");
        XPP3AnimationXMLWriter.writeAnimation(xs, a, file, source, syncPointGroups);
        xs.endDocument();
        xs.flush();
    }

    public static void writeAnimation(XmlSerializer xs, Animation a, String file, ChannelsParameterSource source, Set<SynchronizedPointGroup> syncPointGroups) throws IOException {
        xs.startTag(AnimationXML.NAMESPACE, "Animation");
        XMLUtils.writeVersionProperty((XmlSerializer)xs, (VersionProperty)a.getVersion(), (String)"Animation");
        xs.startTag(AnimationXML.NAMESPACE, "Channels");
        for (Channel channel : a.getChannels()) {
            XPP3AnimationXMLWriter.writeChannel(xs, channel);
        }
        xs.endTag(AnimationXML.NAMESPACE, "Channels");
        XPP3AnimationXMLWriter.writeAddOnList(xs, a.getAddOns(), file);
        xs.startTag(AnimationXML.NAMESPACE, "ChannelsParameters");
        for (ChannelsParameter param : source.getChannelParameters()) {
            XPP3AnimationXMLWriter.writeChannelsParameter(xs, param);
        }
        xs.endTag(AnimationXML.NAMESPACE, "ChannelsParameters");
        SyncPointGroupXML.XPP3Writer.writeSyncGroups(xs, syncPointGroups);
        xs.endTag(AnimationXML.NAMESPACE, "Animation");
    }

    public static void writeChannel(XmlSerializer xs, Channel channel) throws IOException {
        xs.startTag(AnimationXML.NAMESPACE, "Channel");
        xs.attribute(AnimationXML.NAMESPACE, "id", channel.getId().toString());
        String name = channel.getName();
        if (name != null && !name.isEmpty()) {
            xs.attribute(AnimationXML.NAMESPACE, "name", name);
        }
        xs.startTag(AnimationXML.NAMESPACE, "MotionPaths");
        for (MotionPath mp : channel.getMotionPaths()) {
            XPP3AnimationXMLWriter.writeMotionPath(xs, mp);
        }
        xs.endTag(AnimationXML.NAMESPACE, "MotionPaths");
        xs.endTag(AnimationXML.NAMESPACE, "Channel");
    }

    public static void writeMotionPath(XmlSerializer xs, MotionPath mp) throws IOException {
        xs.startTag(AnimationXML.NAMESPACE, "MotionPath");
        String name = mp.getName();
        if (name != null && !name.isEmpty()) {
            xs.attribute(AnimationXML.NAMESPACE, "name", name);
        }
        XMLUtils.writeVersionProperty((XmlSerializer)xs, (VersionProperty)mp.getInterpolatorVersion(), (String)"Interpolation");
        XPP3AnimationXMLWriter.writeControlPoints(xs, mp.getControlPoints());
        xs.endTag(AnimationXML.NAMESPACE, "MotionPath");
    }

    public static void writeControlPoints(XmlSerializer xs, List<Point2D> points) throws IOException {
        xs.startTag(AnimationXML.NAMESPACE, "ControlPoints");
        for (Point2D p : points) {
            XPP3AnimationXMLWriter.writeControlPoint(xs, p);
        }
        xs.endTag(AnimationXML.NAMESPACE, "ControlPoints");
    }

    public static void writeControlPoint(XmlSerializer xs, Point2D p) throws IOException {
        xs.startTag(AnimationXML.NAMESPACE, "ControlPoint");
        XMLUtils.format((XmlSerializer)xs, (boolean)false);
        xs.startTag(AnimationXML.NAMESPACE, "Time");
        xs.text(Double.valueOf(p.getX()).toString());
        xs.endTag(AnimationXML.NAMESPACE, "Time");
        xs.startTag(AnimationXML.NAMESPACE, "Position");
        xs.text(Double.valueOf(p.getY()).toString());
        xs.endTag(AnimationXML.NAMESPACE, "Position");
        XMLUtils.format((XmlSerializer)xs, (boolean)true);
        xs.endTag(AnimationXML.NAMESPACE, "ControlPoint");
    }

    public static void writeChannelsParameter(XmlSerializer xs, ChannelsParameter param) throws IOException {
        xs.startTag(AnimationXML.NAMESPACE, "ChannelsParameter");
        xs.startTag(AnimationXML.NAMESPACE, "ChannelId");
        xs.text(Integer.toString(param.getChannelID()));
        xs.endTag(AnimationXML.NAMESPACE, "ChannelId");
        xs.startTag(AnimationXML.NAMESPACE, "ChannelName");
        xs.text(param.getChannelName());
        xs.endTag(AnimationXML.NAMESPACE, "ChannelName");
        xs.startTag(AnimationXML.NAMESPACE, "DefaultPosition");
        xs.text(param.getDefaultPosition().toString());
        xs.endTag(AnimationXML.NAMESPACE, "DefaultPosition");
        xs.startTag(AnimationXML.NAMESPACE, "NormalizableRange");
        XPP3AnimationXMLWriter.writeNormalizableRange(xs, param.getNormalizableRange());
        xs.endTag(AnimationXML.NAMESPACE, "NormalizableRange");
        xs.startTag(AnimationXML.NAMESPACE, "GenericParameters");
        for (String key : param.getKeyValuePairs().keySet()) {
            XPP3AnimationXMLWriter.writeGenericParameter(xs, key, (String)param.getKeyValuePairs().get(key));
        }
        xs.endTag(AnimationXML.NAMESPACE, "GenericParameters");
        xs.endTag(AnimationXML.NAMESPACE, "ChannelsParameter");
    }

    public static void writeNormalizableRange(XmlSerializer xs, NormalizableRange range) throws IOException {
        xs.startTag(AnimationXML.NAMESPACE, "Minimum");
        xs.text(range.getMin().toString());
        xs.endTag(AnimationXML.NAMESPACE, "Minimum");
        xs.startTag(AnimationXML.NAMESPACE, "Maximum");
        xs.text(range.getMax().toString());
        xs.endTag(AnimationXML.NAMESPACE, "Maximum");
    }

    public static void writeGenericParameter(XmlSerializer xs, String key, String value) throws IOException {
        xs.startTag(AnimationXML.NAMESPACE, "GenericParameter");
        xs.startTag(AnimationXML.NAMESPACE, "ParameterName");
        xs.text(key);
        xs.endTag(AnimationXML.NAMESPACE, "ParameterName");
        xs.startTag(AnimationXML.NAMESPACE, "ParameterValue");
        xs.text(value);
        xs.endTag(AnimationXML.NAMESPACE, "ParameterValue");
        xs.endTag(AnimationXML.NAMESPACE, "GenericParameter");
    }

    public static void writeAddOnList(XmlSerializer xs, List<ServiceAddOn<Playable>> addons, String animPath) throws IOException {
        if (addons == null || animPath == null) {
            throw new NullPointerException();
        }
        xs.startTag(AnimationXML.NAMESPACE, "AddOns");
        int addonCount = 0;
        for (ServiceAddOn<Playable> addon : addons) {
            String addonPath = animPath + ".addon." + addonCount + ".conf";
            try {
                XPP3AnimationXMLWriter.writeAddOn(xs, addon, addonPath);
            }
            catch (Exception ex) {
                theLogger.log(Level.WARNING, "Error writing AddOn.", ex);
                continue;
            }
            ++addonCount;
        }
        xs.endTag(AnimationXML.NAMESPACE, "AddOns");
    }

    public static void writeAddOn(XmlSerializer xs, ServiceAddOn<Playable> addon, String addonPath) throws Exception {
        if (addon == null || addonPath == null) {
            return;
        }
        ServiceAddOnDriver driver = addon.getAddOnDriver();
        if (driver == null) {
            throw new NullPointerException();
        }
        if (!AddOnUtils.saveAddOnConfig(addon, (String)addonPath)) {
            return;
        }
        xs.startTag(AnimationXML.NAMESPACE, "AddOn");
        XMLUtils.writeVersionProperty((XmlSerializer)xs, (VersionProperty)driver.getServiceVersion(), (String)"ServiceVersion");
        XMLUtils.writeVersionProperty((XmlSerializer)xs, (VersionProperty)driver.getConfigurationFormat(), (String)"configFormatVersion");
        xs.startTag(AnimationXML.NAMESPACE, "AddOnFile");
        xs.text(addonPath);
        xs.endTag(AnimationXML.NAMESPACE, "AddOnFile");
        xs.endTag(AnimationXML.NAMESPACE, "AddOn");
    }
}

