/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.animation.messaging;

import org.jflux.api.core.Adapter;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.protocol.AnimationEvent;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.avrogen.animation.AnimationEventRecord;
import org.robokind.avrogen.animation.AnimationRecord;
import org.robokind.impl.animation.messaging.AnimationMessagingUtils;

public class PortableAnimationEvent
implements AnimationEvent {
    private AnimationEventRecord myAnimationEventRecord;
    private Animation myCachedAnimation;

    public PortableAnimationEvent(AnimationEventRecord eventRec) {
        if (eventRec == null) {
            throw new NullPointerException();
        }
        this.myAnimationEventRecord = eventRec;
    }

    public PortableAnimationEvent(AnimationEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        if (event instanceof PortableAnimationEvent) {
            PortableAnimationEvent pEvent = (PortableAnimationEvent)event;
            this.myAnimationEventRecord = pEvent.getRecord();
            this.myCachedAnimation = pEvent.getAnimation();
            return;
        }
        this.buildRecord(event.getSourceId(), event.getDestinationId(), event.getCurrentTimeMillisec(), event.getAnimation());
    }

    public PortableAnimationEvent(String sourceId, String destinationId, long currentTime, Animation anim) {
        this.buildRecord(sourceId, destinationId, currentTime, anim);
    }

    private void buildRecord(String sourceId, String destinationId, long currentTime, Animation anim) {
        if (sourceId == null || destinationId == null || anim == null) {
            throw new NullPointerException();
        }
        AnimationEventRecord eventRec = new AnimationEventRecord();
        eventRec.setSourceId(sourceId);
        eventRec.setDestinationId(destinationId);
        eventRec.setCurrentTimeMillisec(Long.valueOf(currentTime));
        AnimationRecord animRec = AnimationMessagingUtils.packAnimation(anim);
        eventRec.setAnimation(animRec);
        this.myAnimationEventRecord = eventRec;
        this.myCachedAnimation = anim;
    }

    public String getSourceId() {
        return this.myAnimationEventRecord.getSourceId();
    }

    public String getDestinationId() {
        return this.myAnimationEventRecord.getDestinationId();
    }

    public Long getCurrentTimeMillisec() {
        return this.myAnimationEventRecord.getCurrentTimeMillisec();
    }

    public Animation getAnimation() {
        if (this.myCachedAnimation == null) {
            AnimationRecord animRec = this.myAnimationEventRecord.getAnimation();
            this.myCachedAnimation = AnimationMessagingUtils.unpackAnimation(animRec);
        }
        return this.myCachedAnimation;
    }

    public AnimationEventRecord getRecord() {
        return this.myAnimationEventRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<AnimationEventRecord, AnimationEvent> {
        public AnimationEvent adapt(AnimationEventRecord a) {
            return new PortableAnimationEvent(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<AnimationEvent, AnimationEventRecord> {
        public AnimationEventRecord adapt(AnimationEvent a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableAnimationEvent(a).getRecord();
        }
    }

    public static class Factory
    implements AnimationEvent.AnimationEventFactory {
        public AnimationEvent createAnimationEvent(String clientId, String hostId, Animation animation) {
            if (clientId == null || hostId == null || animation == null) {
                throw new NullPointerException();
            }
            return new PortableAnimationEvent(clientId, hostId, TimeUtils.now(), animation);
        }
    }
}

