/*
 * Copyright 2011 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.robokind.impl.animation.osgi;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.Channel;
import org.robokind.api.animation.MotionPath;
import org.robokind.api.animation.protocol.AnimationEvent;
import org.robokind.api.animation.protocol.PlayRequest;
import org.robokind.api.animation.xml.AnimationFileReader;
import org.robokind.api.animation.xml.AnimationFileWriter;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.lifecycle.utils.SimpleLifecycle;
import org.robokind.api.common.osgi.lifecycle.OSGiComponent;
import org.robokind.api.common.osgi.lifecycle.OSGiComponentFactory;
import org.robokind.api.interpolation.linear.LinearInterpolatorFactory;
import org.robokind.avrogen.animation.AnimationEventRecord;
import org.robokind.avrogen.animation.PlayRequestRecord;
import org.robokind.impl.animation.messaging.PortableAnimationEvent;
import org.robokind.impl.animation.messaging.PortablePlayRequest;
import org.robokind.impl.animation.xml.AnimationXMLReader;
import org.robokind.impl.animation.xml.ApacheAnimationXMLWriter;
import org.robokind.impl.animation.xml.XPP3AnimationXMLWriter;
import org.robokind.impl.messaging.JMSAvroServiceFacade;
import org.robokind.impl.messaging.config.RKMessagingConfigUtils;

/**
 * 
 * @author Matthew Stevenson <www.robokind.org>
 */
public class Activator implements BundleActivator {
    private final static Logger theLogger = 
            Logger.getLogger(Activator.class.getName());

    @Override
    public void start(BundleContext context) throws Exception {
        theLogger.log(Level.INFO, "AnimationImpl Activation Begin.");
        new OSGiComponent(context, new SimpleLifecycle(
                new AnimationXMLReader(), AnimationFileReader.class)).start();
        
        new OSGiComponent(context, new SimpleLifecycle(
                new XPP3AnimationXMLWriter(), AnimationFileWriter.class)).start();
        
        RKMessagingConfigUtils.registerAvroSerializationConfig(
                AnimationEvent.class, 
                AnimationEventRecord.class, 
                AnimationEventRecord.SCHEMA$, 
                new PortableAnimationEvent.MessageRecordAdapter(), 
                new PortableAnimationEvent.RecordMessageAdapter(), 
                JMSAvroServiceFacade.AVRO_MIME_TYPE, null, 
                new OSGiComponentFactory(context));
        
        RKMessagingConfigUtils.registerAvroSerializationConfig(
                PlayRequest.class, 
                PlayRequestRecord.class, 
                PlayRequestRecord.SCHEMA$, 
                new PortablePlayRequest.MessageRecordAdapter(), 
                new PortablePlayRequest.RecordMessageAdapter(), 
                JMSAvroServiceFacade.AVRO_MIME_TYPE, null, 
                new OSGiComponentFactory(context));
        theLogger.log(Level.INFO, "AnimationImpl Activation Complete.");
    }

    @Override
    public void stop(BundleContext context) throws Exception {
    }

}
