/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.animation.messaging;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.Channel;
import org.robokind.api.animation.MotionPath;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.interpolation.InterpolatorDirectory;
import org.robokind.api.interpolation.InterpolatorFactory;
import org.robokind.impl.animation.messaging.AnimationRecord;
import org.robokind.impl.animation.messaging.ChannelRecord;
import org.robokind.impl.animation.messaging.ControlPointRecord;
import org.robokind.impl.animation.messaging.InterpolatorTypeRecord;
import org.robokind.impl.animation.messaging.MotionPathRecord;

public class AnimationMessagingUtils {
    public static AnimationRecord packAnimation(Animation animation) {
        if (animation == null) {
            throw new NullPointerException();
        }
        AnimationRecord animRec = new AnimationRecord();
        animRec.setName(animation.getVersion().getName());
        animRec.setVersionNumber(animation.getVersion().getNumber());
        animRec.setStartTime(animation.getStartTime());
        animRec.setStopTime(animation.getStopTime());
        Schema arraySchema = Schema.createArray((Schema)ChannelRecord.SCHEMA$);
        List chanList = animation.getChannels();
        GenericData.Array channels = new GenericData.Array(chanList.size(), arraySchema);
        for (Channel chan : chanList) {
            channels.add((Object)AnimationMessagingUtils.packChannel(chan));
        }
        animRec.setChannels((List<ChannelRecord>)channels);
        return animRec;
    }

    private static ChannelRecord packChannel(Channel channel) {
        ChannelRecord chanRec = new ChannelRecord();
        chanRec.setName(channel.getName());
        chanRec.setChannelId(channel.getId());
        chanRec.setStartTime(channel.getStartTime());
        chanRec.setStopTime(channel.getStopTime());
        Schema arraySchema = Schema.createArray((Schema)MotionPathRecord.SCHEMA$);
        List pathList = channel.getMotionPaths();
        GenericData.Array paths = new GenericData.Array(pathList.size(), arraySchema);
        int i = 0;
        for (MotionPath mp : pathList) {
            paths.add((Object)AnimationMessagingUtils.packMotionPath(mp, i++));
        }
        chanRec.setMotionPaths((List<MotionPathRecord>)paths);
        return chanRec;
    }

    private static MotionPathRecord packMotionPath(MotionPath path, int id) {
        MotionPathRecord pathRec = new MotionPathRecord();
        pathRec.setName(path.getName());
        pathRec.setMotionPathId(id);
        pathRec.setStartTime(path.getStartTime());
        pathRec.setStopTime(path.getStopTime());
        VersionProperty interpVersion = path.getInterpolatorVersion();
        pathRec.setInterpolator(AnimationMessagingUtils.packInterpolatorType(interpVersion));
        Schema arraySchema = Schema.createArray((Schema)ControlPointRecord.SCHEMA$);
        List pointList = path.getControlPoints();
        GenericData.Array points = new GenericData.Array(pointList.size(), arraySchema);
        for (Point2D p : pointList) {
            points.add((Object)AnimationMessagingUtils.packControlPoint(p));
        }
        pathRec.setControlPoints((List<ControlPointRecord>)points);
        return pathRec;
    }

    private static InterpolatorTypeRecord packInterpolatorType(VersionProperty prop) {
        InterpolatorTypeRecord interp = new InterpolatorTypeRecord();
        interp.setName(prop.getName());
        interp.setVersionNumber(prop.getNumber());
        return interp;
    }

    private static ControlPointRecord packControlPoint(Point2D point) {
        ControlPointRecord pointRec = new ControlPointRecord();
        pointRec.setTime((long)point.getX());
        pointRec.setPosition(point.getY());
        return pointRec;
    }

    public static Animation unpackAnimation(AnimationRecord animRec) {
        String name = animRec.getName();
        String number = animRec.getVersionNumber();
        VersionProperty animVersion = new VersionProperty(name, number);
        Animation anim = new Animation(animVersion);
        for (ChannelRecord chanRec : animRec.getChannels()) {
            anim.addChannel(AnimationMessagingUtils.unpackChannel(chanRec));
        }
        if (animRec.getStartTime() != null) {
            anim.setStartTime(animRec.getStartTime());
        }
        if (animRec.getStopTime() != null) {
            anim.setStopTime(animRec.getStopTime());
        }
        return anim;
    }

    private static Channel unpackChannel(ChannelRecord chanRec) {
        Channel chan = new Channel(chanRec.getChannelId().intValue(), chanRec.getName());
        for (MotionPathRecord pathRec : chanRec.getMotionPaths()) {
            chan.addPath(AnimationMessagingUtils.unpackMotionPath(pathRec));
        }
        if (chanRec.getStartTime() != null) {
            chan.setStartTime(chanRec.getStartTime());
        }
        if (chanRec.getStopTime() != null) {
            chan.setStopTime(chanRec.getStopTime());
        }
        return chan;
    }

    private static MotionPath unpackMotionPath(MotionPathRecord pathRec) {
        String interpName = pathRec.getInterpolator().getName();
        String interpNumber = pathRec.getInterpolator().getVersionNumber();
        VersionProperty interp = new VersionProperty(interpName, interpNumber);
        InterpolatorFactory fact = InterpolatorDirectory.instance().getFactory(interp);
        MotionPath path = new MotionPath(fact);
        path.setName(pathRec.getName());
        int pointCount = pathRec.getControlPoints().size();
        ArrayList<Point2D> points = new ArrayList<Point2D>(pointCount);
        for (ControlPointRecord pr : pathRec.getControlPoints()) {
            points.add(AnimationMessagingUtils.unpackControlPoint(pr));
        }
        path.addPoints(points);
        if (pathRec.getStartTime() != null) {
            path.setStartTime(pathRec.getStartTime());
        }
        if (pathRec.getStopTime() != null) {
            path.setStopTime(pathRec.getStopTime());
        }
        return path;
    }

    private static Point2D unpackControlPoint(ControlPointRecord pointRec) {
        return new Point2D.Double(pointRec.getTime().longValue(), pointRec.getPosition());
    }
}

