/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.animation.messaging;

import java.util.List;
import org.jflux.api.core.Adapter;
import org.robokind.api.animation.protocol.AnimationSignal;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.impl.animation.messaging.AnimationSignallingRecord;

public class PortableAnimationSignal
implements AnimationSignal {
    private AnimationSignallingRecord myAnimationSignallingRecord;

    public PortableAnimationSignal(AnimationSignallingRecord signalRec) {
        if (signalRec == null) {
            throw new NullPointerException();
        }
        this.myAnimationSignallingRecord = signalRec;
    }

    public PortableAnimationSignal(AnimationSignal signal) {
        if (signal == null) {
            throw new NullPointerException();
        }
        if (signal instanceof PortableAnimationSignal) {
            PortableAnimationSignal pSignal = (PortableAnimationSignal)signal;
            this.myAnimationSignallingRecord = pSignal.getRecord();
            return;
        }
        this.buildRecord(signal.getSourceId(), signal.getTimestampMillisecUTC(), signal.getEventType(), signal.getAnimationName(), signal.getAnimationVersion(), signal.getAnimationHash(), signal.getAnimationLength(), signal.getAnimationProperties());
    }

    public PortableAnimationSignal(String sourceId, long timestampMillisecUTC, String eventType, String animationName, String animationVersion, int animationHash, long animationLength, List<String> animationProperties) {
        this.buildRecord(sourceId, timestampMillisecUTC, eventType, animationName, animationVersion, animationHash, animationLength, animationProperties);
    }

    private void buildRecord(String sourceId, long timestampMillisecUTC, String eventType, String animationName, String animationVersion, int animationHash, long animationLength, List<String> animationProperties) {
        if (sourceId == null || eventType == null || animationName == null || animationVersion == null || animationProperties == null) {
            throw new NullPointerException();
        }
        AnimationSignallingRecord signalRec = new AnimationSignallingRecord();
        signalRec.setSourceId(sourceId);
        signalRec.setTimestampMillisecUTC(timestampMillisecUTC);
        signalRec.setEventType(eventType);
        signalRec.setAnimationName(animationName);
        signalRec.setAnimationVersion(animationVersion);
        signalRec.setAnimationHash(animationHash);
        signalRec.setAnimationLength(animationLength);
        signalRec.setAnimationProperties(animationProperties);
        this.myAnimationSignallingRecord = signalRec;
    }

    public String getSourceId() {
        return this.myAnimationSignallingRecord.getSourceId();
    }

    public Long getTimestampMillisecUTC() {
        return this.myAnimationSignallingRecord.getTimestampMillisecUTC();
    }

    public String getEventType() {
        return this.myAnimationSignallingRecord.getEventType();
    }

    public String getAnimationName() {
        return this.myAnimationSignallingRecord.getAnimationName();
    }

    public String getAnimationVersion() {
        return this.myAnimationSignallingRecord.getAnimationVersion();
    }

    public Integer getAnimationHash() {
        return this.myAnimationSignallingRecord.getAnimationHash();
    }

    public Long getAnimationLength() {
        return this.myAnimationSignallingRecord.getAnimationLength();
    }

    public List<String> getAnimationProperties() {
        return this.myAnimationSignallingRecord.getAnimationProperties();
    }

    public AnimationSignallingRecord getRecord() {
        return this.myAnimationSignallingRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<AnimationSignallingRecord, AnimationSignal> {
        public AnimationSignal adapt(AnimationSignallingRecord a) {
            return new PortableAnimationSignal(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<AnimationSignal, AnimationSignallingRecord> {
        public AnimationSignallingRecord adapt(AnimationSignal a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableAnimationSignal(a).getRecord();
        }
    }

    public static class Factory
    implements AnimationSignal.AnimationSignalFactory {
        public AnimationSignal createAnimationSignal(String sourceId, String eventType, String animationName, String animationVersion, int animationHash, long animationLength, List<String> animationProperties) {
            if (sourceId == null || eventType == null || animationName == null || animationVersion == null || animationProperties == null) {
                throw new NullPointerException();
            }
            return new PortableAnimationSignal(sourceId, TimeUtils.now(), eventType, animationName, animationVersion, animationHash, animationLength, animationProperties);
        }
    }
}

