/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.audio.processing;

import java.util.logging.Logger;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.transform.FastFourierTransformer;
import org.robokind.api.audio.processing.FFTWindow;
import org.robokind.api.audio.processing.MeanCalculator;

public class FFTBuffer {
    private static final Logger theLogger = Logger.getLogger(FFTBuffer.class.getName());
    private MeanCalculator myMean;
    private FFTWindow myWindow;
    private Complex[][] myFFTData;
    private int mySize;
    private int myChannels;
    private boolean myRealitime;

    public FFTBuffer(int channels, int size, MeanCalculator mean, FFTWindow win, boolean realtime) {
        this.myRealitime = realtime;
        this.myChannels = channels;
        this.myMean = mean;
        this.myWindow = win;
        this.mySize = size;
        this.myFFTData = new Complex[this.myChannels][this.mySize];
    }

    public void writeData(double[][] data) {
        boolean window;
        boolean normalize = this.myMean != null;
        boolean bl = window = this.myWindow != null;
        if (this.myRealitime && window) {
            this.myMean.processSamples(data, 0, 0);
        }
        for (int c = 0; c < this.myChannels; ++c) {
            int i = 0;
            FastFourierTransformer fft = new FastFourierTransformer();
            double[] temp = new double[this.mySize];
            for (double x : data[c]) {
                if (normalize) {
                    x = this.myMean.normalize(c, x);
                }
                if (window) {
                    x = this.myWindow.applyWindow(i, x);
                }
                temp[i] = x;
                ++i;
            }
            this.myFFTData[c] = fft.transform(temp);
        }
    }

    public Complex[][] getData() {
        return this.myFFTData;
    }
}

