/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.audio.config;

import java.io.File;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.util.Utf8;
import org.robokind.api.audio.config.WavPlayerConfig;
import org.robokind.avrogen.audio.WavPlayerConfigRecord;
import org.robokind.bind.apache_avro.AvroUtils;

public class PortableWavPlayerConfig
implements WavPlayerConfig {
    private WavPlayerConfigRecord myConfigRecord;

    public PortableWavPlayerConfig(WavPlayerConfigRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myConfigRecord = record;
    }

    public PortableWavPlayerConfig(WavPlayerConfig config) {
        if (config == null) {
            throw new NullPointerException();
        }
        if (config instanceof PortableWavPlayerConfig) {
            this.myConfigRecord = ((PortableWavPlayerConfig)config).myConfigRecord;
            return;
        }
        this.myConfigRecord = new WavPlayerConfigRecord();
        this.myConfigRecord.wavPlayerId = new Utf8(config.getWavPlayerId());
        this.myConfigRecord.wavLocation = new Utf8(config.getWavLocation());
        this.myConfigRecord.startTimeMicrosec = config.getStartTimeMicrosec();
        this.myConfigRecord.stopTimeMicrosec = config.getStopTimeMicrosec();
        this.myConfigRecord.startDelayMillisec = config.getStartDelayMillisec();
    }

    public PortableWavPlayerConfig(String playerId, String wavLocation, long startTimeMicrosec, long stopTimeMicrosec, long startDelayMillisec) {
        if (playerId == null || wavLocation == null) {
            throw new NullPointerException();
        }
        this.myConfigRecord = new WavPlayerConfigRecord();
        this.myConfigRecord.wavPlayerId = new Utf8(playerId);
        this.myConfigRecord.wavLocation = new Utf8(wavLocation);
        this.myConfigRecord.startTimeMicrosec = startTimeMicrosec;
        this.myConfigRecord.stopTimeMicrosec = stopTimeMicrosec;
        this.myConfigRecord.startDelayMillisec = startDelayMillisec;
    }

    public String getWavPlayerId() {
        return this.myConfigRecord.wavPlayerId.toString();
    }

    public String getWavLocation() {
        return this.myConfigRecord.wavLocation.toString();
    }

    public long getStartTimeMicrosec() {
        return this.myConfigRecord.startTimeMicrosec;
    }

    public long getStopTimeMicrosec() {
        return this.myConfigRecord.stopTimeMicrosec;
    }

    public long getStartDelayMillisec() {
        return this.myConfigRecord.startDelayMillisec;
    }

    public WavPlayerConfigRecord getRecord() {
        return this.myConfigRecord;
    }

    public static void writeToFile(File file, WavPlayerConfig config) throws Exception {
        if (file == null || config == null) {
            throw new NullPointerException();
        }
        PortableWavPlayerConfig portableConfig = config instanceof PortableWavPlayerConfig ? (PortableWavPlayerConfig)config : new PortableWavPlayerConfig(config);
        WavPlayerConfigRecord record = portableConfig.getRecord();
        AvroUtils.writeToFile((IndexedRecord)record, (Schema)WavPlayerConfigRecord.SCHEMA$, (File)file, (boolean)true);
    }
}

