package org.robokind.impl.audio.osgi;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.audio.WavBufferPlayer;
import org.robokind.api.audio.WavPlayer;
import org.robokind.api.audio.config.WavPlayerConfig;
import org.robokind.api.common.services.ServiceUtils;
import org.robokind.api.common.services.addon.AddOnUtils;
import org.robokind.api.common.services.addon.DefaultAddOnDriver;
import org.robokind.api.common.services.addon.ServiceAddOnDriver;
import org.robokind.impl.audio.config.WavPlayerConfigAdapter;
import org.robokind.impl.audio.config.WavPlayerConfigLoader;
import org.robokind.impl.audio.config.WavPlayerConfigWriter;

public class Activator implements BundleActivator {
    private final static Logger theLogger = 
            Logger.getLogger(Activator.class.getName());

    @Override
    public void start(BundleContext context) throws Exception {
        theLogger.log(Level.INFO, "org.robokind.impl.audio Activation Begin.");
        ServiceUtils.registerConfigLoader(
                context, new WavPlayerConfigLoader(), null);
        ServiceUtils.registerConfigWriter(
                context, new WavPlayerConfigWriter(), null);
        ServiceRegistration driverReg = registerWavPlayerAddOnDriver(context);
        theLogger.log(Level.INFO, 
                "org.robokind.impl.audio Activation Complete.");
    }
    
    private ServiceRegistration registerWavPlayerAddOnDriver(BundleContext context){
        WavPlayerConfigAdapter adapter = new WavPlayerConfigAdapter();
        ServiceAddOnDriver<WavPlayer> driver = 
                new DefaultAddOnDriver<WavPlayer, WavPlayerConfig>(context, 
                        WavBufferPlayer.VERSION, 
                        WavPlayerConfigLoader.VERSION, 
                        adapter);
        return AddOnUtils.registerAddOnDriver(context, driver, null);
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        // TODO add deactivation code here
    }

}
