/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.audio.config;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.robokind.api.audio.config.WavPlayerConfig;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.services.ConfigurationWriter;
import org.robokind.bind.apache_avro.AvroUtils;
import org.robokind.impl.audio.config.WavPlayerConfigLoader;
import org.robokind.impl.audio.config.WavPlayerConfigRecord;

public class WavPlayerConfigWriter
implements ConfigurationWriter<WavPlayerConfig, File> {
    public VersionProperty getConfigurationFormat() {
        return WavPlayerConfigLoader.VERSION;
    }

    public boolean writeConfiguration(WavPlayerConfig config, File param) throws IOException {
        WavPlayerConfigRecord record;
        if (config == null || param == null) {
            throw new NullPointerException();
        }
        if (config instanceof WavPlayerConfigRecord) {
            record = (WavPlayerConfigRecord)config;
        } else {
            WavPlayerConfigRecord.Builder builder = WavPlayerConfigRecord.newBuilder();
            builder.setWavPlayerId(config.getWavPlayerId());
            builder.setWavLocation(config.getWavLocation());
            builder.setStartTimeMicrosec(config.getStartTimeMicrosec());
            builder.setStopTimeMicrosec(config.getStopTimeMicrosec());
            builder.setStartDelayMillisec(config.getStartDelayMillisec());
            record = builder.build();
        }
        return AvroUtils.writeToFile((IndexedRecord)record, (Schema)WavPlayerConfigRecord.SCHEMA$, (File)param, (boolean)true);
    }

    public Class<WavPlayerConfig> getConfigurationClass() {
        return WavPlayerConfig.class;
    }

    public Class<File> getParameterClass() {
        return File.class;
    }
}

