/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.audio.visualization;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import org.apache.commons.math.complex.Complex;
import org.robokind.api.audio.processing.FFTWindow;
import org.robokind.api.audio.processing.HammingWindow;
import org.robokind.api.audio.processing.MeanCalculator;
import org.robokind.api.audio.processing.SampleProcessor;
import org.robokind.api.audio.processing.WavProcessor;
import org.robokind.impl.audio.processing.FFTBuffer;

public class SpectrogramImage {
    private double myNormalize;
    private int myOverlapCount;
    private int myImageColumnIndex;
    private int myFFTLen;
    private int myFFTHalfLen;
    private int myChannelCount;
    private BufferedImage[] myChannelImages;
    private WavProcessor myWavProc;
    private FFTBuffer myFFT;
    private MeanCalculator myMean;
    private FFTWindow myWindow;
    private SpectrogramProcessor myProc;

    public SpectrogramImage(WavProcessor wavProc, int fftLen, int channels, double normalizationFactor) {
        this.myWavProc = wavProc;
        this.myWavProc.setSamplesBufferSize(fftLen);
        this.myFFTLen = fftLen;
        this.myFFTHalfLen = fftLen / 2;
        this.myImageColumnIndex = 0;
        this.myNormalize = normalizationFactor;
        this.myOverlapCount = 1;
        AudioFormat format = this.myWavProc.getFormat();
        if (format == null) {
            throw new NullPointerException();
        }
        this.myChannelCount = format.getChannels();
        this.myChannelImages = new BufferedImage[this.myChannelCount];
        this.myProc = new SpectrogramProcessor();
        this.myMean = new MeanCalculator(this.myChannelCount);
        this.initImage();
        this.initFFTBuffer();
    }

    public MeanCalculator getMeanCalculator() {
        return this.myMean;
    }

    private void initImage() {
        long frame = this.myWavProc.getFrameCount();
        int width = (int)(frame * (long)this.myOverlapCount / (long)this.myFFTLen) + 1;
        int height = this.myFFTHalfLen;
        for (int c = 0; c < this.myChannelCount; ++c) {
            this.myChannelImages[c] = new BufferedImage(width, height, 1);
        }
    }

    private void initFFTBuffer() {
        this.myWindow = new HammingWindow(this.myFFTLen);
        this.myFFT = new FFTBuffer(this.myChannelCount, this.myFFTLen, this.myMean, this.myWindow, false);
    }

    public void createSpectrograms() {
        this.myWavProc.process((SampleProcessor)this.myMean);
        this.myWavProc.reset();
        this.myWavProc.process((SampleProcessor)this.myProc);
    }

    private void addData(int c, Complex[] data) {
        for (int i = 0; i < this.myFFTHalfLen; ++i) {
            double mag = data[i + this.myFFTHalfLen].abs();
            mag = Math.log10(mag) / this.myNormalize;
            int rgb = this.getColor(mag);
            this.myChannelImages[c].setRGB(this.myImageColumnIndex, i, rgb);
        }
    }

    private int getColor(double mag) {
        int db = (int)Math.min(Math.max(0.0, mag * 1023.0), 1023.0);
        int rgb = 0;
        rgb = db < 128 ? this.getRGB(0, 0, db) : (db < 384 ? this.getRGB(db - 128, 0, 128) : (db < 512 ? this.getRGB(255, 0, 512 - db) : (db < 768 ? this.getRGB(255, db - 512, 0) : this.getRGB(255, 255, db - 768))));
        return rgb;
    }

    private int getRGB(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public Image getImage(int c) {
        return this.myChannelImages[c];
    }

    public void addProcessorListener(SampleProcessor.ProcessorListener listener) {
        this.myProc.addProcessorListener(listener);
    }

    public void removeProcessorListener(SampleProcessor.ProcessorListener listener) {
        this.myProc.removeProcessorListener(listener);
    }

    private class SpectrogramProcessor
    implements SampleProcessor {
        private List<SampleProcessor.ProcessorListener> myListeners = new ArrayList<SampleProcessor.ProcessorListener>(3);

        public void processSamples(double[][] samples, int frame, int total) {
            SpectrogramImage.this.myFFT.writeData(samples);
            Complex[][] data = SpectrogramImage.this.myFFT.getData();
            for (int c = 0; c < SpectrogramImage.this.myChannelCount; ++c) {
                SpectrogramImage.this.addData(c, data[c]);
            }
            SpectrogramImage.this.myImageColumnIndex++;
            this.fireProcessorUpdate(frame, total);
        }

        public void addProcessorListener(SampleProcessor.ProcessorListener listener) {
            if (listener == null || this.myListeners.contains(listener)) {
                return;
            }
            this.myListeners.add(listener);
        }

        public void removeProcessorListener(SampleProcessor.ProcessorListener listener) {
            this.myListeners.remove(listener);
        }

        protected void fireProcessorUpdate(int count, int total) {
            for (SampleProcessor.ProcessorListener pl : this.myListeners) {
                pl.framesProcessed(count, total);
            }
        }
    }
}

