/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.audio.config;

import org.robokind.api.audio.WavBufferPlayer;
import org.robokind.api.audio.WavPlayer;
import org.robokind.api.audio.config.WavPlayerConfig;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.services.ConfigurationAdapter;
import org.robokind.impl.audio.config.WavPlayerConfigLoader;
import org.robokind.impl.audio.config.WavPlayerConfigRecord;

public class WavPlayerConfigAdapter
implements ConfigurationAdapter<WavPlayer, WavPlayerConfig> {
    public WavPlayerConfig createConfig(WavPlayer service) {
        WavPlayerConfigRecord.Builder builder = WavPlayerConfigRecord.newBuilder();
        builder.setWavPlayerId(service.getWavPlayerId());
        builder.setWavLocation(service.getWavBuffer().getAudioLocation());
        builder.setStartTimeMicrosec((long)service.getStartPositionMicrosec());
        builder.setStopTimeMicrosec((long)service.getEndPositionMicrosec());
        builder.setStartDelayMillisec(service.getStartDelayMillisec());
        WavPlayerConfigRecord config = builder.build();
        return config;
    }

    public VersionProperty getServiceVersion() {
        return WavBufferPlayer.VERSION;
    }

    public VersionProperty getConfigurationFormat() {
        return WavPlayerConfigLoader.VERSION;
    }

    public Class<WavPlayer> getSerivceClass() {
        return WavPlayer.class;
    }

    public Class<WavPlayerConfig> getConfigurationClass() {
        return WavPlayerConfig.class;
    }
}

