/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.avro.generic.IndexedRecord;
import org.robokind.api.messaging.RecordSender;
import org.robokind.bind.apache_qpid.QpidUtils;
import org.robokind.impl.messaging.JMSBytesSender;

public class JMSAvroRecordSender<T extends IndexedRecord>
implements RecordSender<T> {
    static final Logger theLogger = Logger.getLogger(JMSAvroRecordSender.class.getName());
    private JMSBytesSender myBytesSender;

    public JMSAvroRecordSender(JMSBytesSender sender) {
        if (sender == null) {
            throw new NullPointerException();
        }
        this.myBytesSender = sender;
    }

    public void sendRecord(T record) {
        if (record == null) {
            throw new NullPointerException();
        }
        byte[] bytes = null;
        try {
            bytes = QpidUtils.packAvroBytes(record);
        }
        catch (IOException ex) {
            theLogger.log(Level.WARNING, "Error serializing record.", ex);
            return;
        }
        if (bytes == null) {
            theLogger.log(Level.WARNING, "Error serializing record. Null byte array.");
            return;
        }
        this.myBytesSender.sendRecord(bytes);
    }

    public void sendRecord(T record, String contentType) {
        if (record == null) {
            throw new NullPointerException();
        }
        byte[] bytes = null;
        try {
            bytes = QpidUtils.packAvroBytes(record);
        }
        catch (IOException ex) {
            theLogger.log(Level.WARNING, "Error serializing record.", ex);
            return;
        }
        if (bytes == null) {
            theLogger.log(Level.WARNING, "Error serializing record. Null byte array.");
            return;
        }
        this.myBytesSender.sendRecord(bytes, contentType);
    }
}

