/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging;

import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.avro.generic.IndexedRecord;
import org.apache.qpid.client.message.JMSBytesMessage;
import org.robokind.api.common.playable.AbstractPlayable;
import org.robokind.api.messaging.RemoteService;
import org.robokind.avrogen.messaging.ServiceCommand;
import org.robokind.avrogen.messaging.ServiceCommandType;
import org.robokind.bind.apache_qpid.QpidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSAvroServiceFacade<Config extends IndexedRecord>
extends AbstractPlayable
implements RemoteService<Config> {
    private static final Logger theLogger = LoggerFactory.getLogger(JMSAvroServiceFacade.class);
    public static final String CONFIG_MIME_TYPE = "application/config";
    public static final String COMMAND_MIME_TYPE = "application/service-command";
    private Class<Config> myConfigClass;
    private Config myReusableConfig;
    private Session mySession;
    private MessageProducer myCommandSender;
    private MessageConsumer myErrorReceiver;

    public JMSAvroServiceFacade(Class<Config> configClass, Config reusableConfig, Session session, Destination commandDest, Destination errorDest) throws JMSException {
        this.myConfigClass = configClass;
        this.myReusableConfig = reusableConfig;
        this.mySession = session;
        this.myCommandSender = session.createProducer(commandDest);
        this.myErrorReceiver = session.createConsumer(errorDest);
    }

    public JMSAvroServiceFacade(Class<Config> configClass, Config reusableConfig, Session session, MessageProducer commandSender, MessageConsumer errorReceiver) {
        this.myConfigClass = configClass;
        this.myReusableConfig = reusableConfig;
        this.mySession = session;
        this.myCommandSender = commandSender;
        this.myErrorReceiver = errorReceiver;
    }

    public void setSession(Session session) {
        this.mySession = session;
    }

    public void setSender(MessageProducer producer) {
        this.myCommandSender = producer;
    }

    public void setReceiver(MessageConsumer consumer) {
        this.myErrorReceiver = consumer;
    }

    public void initialize(Config config) throws IOException, JMSException, Exception {
        this.send((IndexedRecord)config, CONFIG_MIME_TYPE);
    }

    public boolean onStart(long time) {
        return this.sendCommand(ServiceCommandType.START);
    }

    public boolean onPause(long time) {
        return this.sendCommand(ServiceCommandType.PAUSE);
    }

    public boolean onResume(long time) {
        return this.sendCommand(ServiceCommandType.RESUME);
    }

    public boolean onComplete(long time) {
        return this.sendCommand(ServiceCommandType.STOP);
    }

    public boolean onStop(long time) {
        return this.sendCommand(ServiceCommandType.STOP);
    }

    protected <T extends IndexedRecord> void send(T t, String contentType) throws IOException, JMSException {
        BytesMessage message = this.mySession.createBytesMessage();
        ((JMSBytesMessage)message).setContentType(contentType);
        QpidUtils.packAvroMessage(t, (BytesMessage)message);
        this.myCommandSender.send((Message)message);
    }

    protected boolean sendCommand(ServiceCommandType command) {
        ServiceCommand serviceCmd = new ServiceCommand();
        serviceCmd.command = command;
        try {
            this.send(serviceCmd, COMMAND_MIME_TYPE);
            return true;
        }
        catch (Exception ex) {
            theLogger.error("Error sending Start Command.", (Throwable)ex);
            return false;
        }
    }

    public Class<Config> getConfigClass() {
        return this.myConfigClass;
    }

    public Config getReusableConfig() {
        return this.myReusableConfig;
    }
}

