/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import org.robokind.api.messaging.RecordBlockingReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSBytesRecordBlockingReceiver
implements RecordBlockingReceiver<BytesMessage> {
    private static final Logger theLogger = LoggerFactory.getLogger(JMSBytesRecordBlockingReceiver.class);
    private MessageConsumer myMessageConsumer;

    public JMSBytesRecordBlockingReceiver(MessageConsumer consumer) {
        if (consumer == null) {
            throw new NullPointerException();
        }
        this.myMessageConsumer = consumer;
    }

    public BytesMessage fetchRecord(long timeout) {
        try {
            Message msg = this.myMessageConsumer.receive(timeout);
            if (msg == null) {
                theLogger.error("Request timed out");
                return null;
            }
            msg.acknowledge();
            if (!(msg instanceof BytesMessage)) {
                theLogger.error("Bad Response, Message not instance of BytesMessage.");
                return null;
            }
            return (BytesMessage)msg;
        }
        catch (JMSException ex) {
            theLogger.error("Error fetching BytesMessage.", (Throwable)ex);
            return null;
        }
    }

    public int clearRecords() {
        int cleared = 0;
        try {
            Message msg;
            while ((msg = this.myMessageConsumer.receiveNoWait()) != null) {
                msg.acknowledge();
                ++cleared;
            }
        }
        catch (JMSException ex) {
            theLogger.error("Error clearing Record Receiver.", (Throwable)ex);
        }
        return cleared;
    }
}

