/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.qpid.client.message.JMSBytesMessage;
import org.robokind.api.messaging.RecordSender;

public class JMSBytesSender
implements RecordSender<byte[]> {
    static final Logger theLogger = Logger.getLogger(JMSBytesSender.class.getName());
    private Session mySession;
    private Destination myDestination;
    private MessageProducer myMessageProducer;

    public void setSession(Session session) {
        this.mySession = session;
    }

    public void setDestination(Destination dest) {
        this.myDestination = dest;
    }

    public void closeProducer() {
        if (this.myMessageProducer == null) {
            return;
        }
        try {
            this.myMessageProducer.close();
        }
        catch (JMSException ex) {
            theLogger.log(Level.WARNING, "Error closing MessageProducer.", ex);
        }
    }

    public void openProducer() {
        if (this.mySession == null || this.myDestination == null) {
            return;
        }
        if (this.myMessageProducer != null) {
            theLogger.log(Level.WARNING, "Cannot open MessageProducer.  MessageProducer already open.");
            return;
        }
        try {
            this.myMessageProducer = this.mySession.createProducer(this.myDestination);
        }
        catch (JMSException ex) {
            theLogger.log(Level.WARNING, "Error opening MessageProducer.", ex);
        }
    }

    public void sendRecord(byte[] bytes) {
        this.sendRecord(bytes, 0, bytes.length, null);
    }

    public void sendRecord(byte[] bytes, String contentType) {
        this.sendRecord(bytes, 0, bytes.length, contentType);
    }

    public void sendRecord(byte[] bytes, int offset, int len, String contentType) {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (this.mySession == null || this.myMessageProducer == null) {
            theLogger.log(Level.INFO, "Not connected, unable to send message.");
            return;
        }
        try {
            BytesMessage msg = this.mySession.createBytesMessage();
            msg.writeBytes(bytes, offset, len);
            if (contentType != null) {
                ((JMSBytesMessage)msg).setContentType(contentType);
                ((JMSBytesMessage)msg).setEncoding(contentType);
            }
            this.myMessageProducer.send((Message)msg);
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "Error sending message.", ex);
        }
    }
}

