/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Session;
import org.apache.avro.generic.IndexedRecord;
import org.apache.qpid.client.message.JMSBytesMessage;
import org.robokind.api.common.utils.Adapter;
import org.robokind.api.common.utils.ComplexAdapter;
import org.robokind.api.common.utils.Factory;
import org.robokind.api.common.utils.PolymorphicAdapter;
import org.robokind.bind.apache_qpid.QpidUtils;
import org.robokind.impl.messaging.BytesMessageFactory;

public class JMSAvroPolymorphicRecordBytesAdapter<Msg>
implements Adapter<Msg, BytesMessage> {
    static final Logger theLogger = Logger.getLogger(JMSAvroPolymorphicRecordBytesAdapter.class.getName());
    private PolymorphicAdapter<Msg, BytesMessage> myAdapter;
    private BytesMessageFactory myBytesMessageFactory;

    public JMSAvroPolymorphicRecordBytesAdapter(PolymorphicAdapter.AdapterKeyMap<Msg> keyMap) {
        if (keyMap == null) {
            throw new NullPointerException();
        }
        this.myAdapter = new PolymorphicAdapter(keyMap);
        this.myBytesMessageFactory = new BytesMessageFactory();
    }

    public void setSession(Session session) {
        this.myBytesMessageFactory.setSession(session);
    }

    public <R extends IndexedRecord> void addAdapter(Adapter<Msg, R> adapter, String contentType) {
        if (adapter == null || contentType == null) {
            throw new NullPointerException();
        }
        JMSAvroRecordBytesAdapter bytesAdapter = new JMSAvroRecordBytesAdapter(this.myBytesMessageFactory, contentType);
        ComplexAdapter complexAdapter = new ComplexAdapter(adapter, bytesAdapter);
        this.myAdapter.addAdapter(contentType, (Adapter)complexAdapter);
    }

    public BytesMessage adapt(Msg a) {
        return (BytesMessage)this.myAdapter.adapt(a);
    }

    public static class JMSAvroRecordBytesAdapter<A extends IndexedRecord>
    implements Adapter<A, BytesMessage> {
        private String myContentType;
        private Factory<JMSBytesMessage> myBytesMessageFactory;

        public JMSAvroRecordBytesAdapter(Factory<JMSBytesMessage> messageFactory, String contentType) {
            if (messageFactory == null) {
                throw new NullPointerException();
            }
            this.myBytesMessageFactory = messageFactory;
            this.myContentType = contentType;
        }

        public BytesMessage adapt(A a) {
            JMSBytesMessage message = (JMSBytesMessage)this.myBytesMessageFactory.create();
            if (message == null) {
                theLogger.warning("The factory failed to create a BytesMessage.");
                return null;
            }
            try {
                QpidUtils.packAvroMessage(a, (BytesMessage)message);
                if (this.myContentType != null) {
                    message.setContentType(this.myContentType);
                    message.setEncoding(this.myContentType);
                }
                return message;
            }
            catch (Exception ex) {
                theLogger.log(Level.WARNING, "There was an error packing the JMSBytesMessage.", ex);
                return null;
            }
        }
    }
}

