/*
 * Copyright 2012 Hanson Robokind LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robokind.impl.messaging.utils;

/**
 * Unused
 * @author Matthew Stevenson <www.robokind.org>
 */
public class DestinationConfig {
    public final static int TYPE_QUEUE = 0;
    public final static int TYPE_TOPIC = 1;
    
    private String myDestinationId;
    private String myDestinationString;
    
    public static DestinationConfig build(
            String id, String destinationName, int type){
        if(id == null || destinationName == null){
            throw new NullPointerException();
        }
        String destStr = buildNameString(destinationName, type);
        return new DestinationConfig(id, destStr);
    }
    
    public static DestinationConfig buildQueue(
            String id, String destinationName){
        return build(id, destinationName, TYPE_QUEUE);
    }
    
    public static DestinationConfig buildTopic(
            String id, String destinationName){
        return build(id, destinationName, TYPE_QUEUE);
    }
    
    private static void validateType(int type){
        if(type != TYPE_QUEUE && type != TYPE_TOPIC){
            throw new IllegalArgumentException("Invalid type: " + type + ".  "
                    + "See DestinationDescriptor for available types.");
        }
    }
    
    private static String buildNameString(String destName, int type){
        validateType(type);
        String fullName = destName;
        if(type == TYPE_QUEUE){
            fullName += "; {create: always, node: {type: queue}}";
        }else if(type ==TYPE_TOPIC){
            fullName += "; {create: always, node: {type: topic}}";
        }
        return fullName;
    }
    
    public DestinationConfig(
            String destinationId, String destinationStr){
        if(destinationId == null || destinationStr == null){
            throw new NullPointerException();
        }
        myDestinationId = destinationId;
        myDestinationString = destinationStr;
    }
    
    public String getDestinationId(){
        return myDestinationId;
    }
    
    public String getDestinationString(){
        return myDestinationString;
    }
}
