/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging;

import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.avro.generic.IndexedRecord;
import org.robokind.api.messaging.DefaultMessageSender;
import org.robokind.impl.messaging.JMSAvroRecordSender;
import org.robokind.impl.messaging.JMSBytesMessageSender;

public class JMSAvroMessageSender<Msg, Rec extends IndexedRecord>
extends DefaultMessageSender<Msg, Rec> {
    private static final Logger theLogger = Logger.getLogger(JMSAvroMessageSender.class.getName());
    private JMSBytesMessageSender myBytesSender;
    private String myDefaultContentType;

    public JMSAvroMessageSender(Session session, Destination destination) {
        if (session == null || destination == null) {
            throw new NullPointerException();
        }
        this.myBytesSender = new JMSBytesMessageSender();
        this.myBytesSender.setSession(session);
        this.myBytesSender.setDestination(destination);
    }

    public JMSAvroMessageSender(JMSBytesMessageSender sender) {
        if (sender == null) {
            throw new NullPointerException();
        }
        this.myBytesSender = sender;
    }

    public void start() {
        this.myBytesSender.openProducer();
        JMSAvroRecordSender recordSender = new JMSAvroRecordSender(this.myBytesSender);
        this.setRecordSender(recordSender);
    }

    public void stop() {
        if (this.myRecordSender == null || !(this.myRecordSender instanceof JMSAvroRecordSender)) {
            return;
        }
        this.myBytesSender.closeProducer();
    }

    public void setDefaultContentType(String contentType) {
        this.myDefaultContentType = contentType;
    }

    public void sendMessage(Msg message) {
        if (this.myDefaultContentType == null) {
            super.sendMessage(message);
        } else {
            this.sendMessage(message, this.myDefaultContentType);
        }
    }

    public void sendMessage(Msg message, String contentType) {
        IndexedRecord record = (IndexedRecord)this.getRecord(message);
        if (record == null) {
            theLogger.warning("Adapter returned null Record, unable to send message.");
            return;
        }
        if (this.myRecordSender instanceof JMSAvroRecordSender) {
            ((JMSAvroRecordSender)this.myRecordSender).sendRecord(record, contentType);
        } else {
            this.myRecordSender.sendRecord((Object)record);
        }
    }
}

