/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging.lifecycle;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.jflux.api.core.util.Adapter;
import org.robokind.api.common.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.DescriptorListBuilder;
import org.robokind.api.messaging.DefaultMessageAsyncReceiver;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.impl.messaging.JMSAvroRecordAsyncReceiver;

public class JMSAvroAsyncReceiverLifecycle<Msg, Rec extends IndexedRecord>
extends AbstractLifecycleProvider<MessageAsyncReceiver, DefaultMessageAsyncReceiver<Msg, Rec>> {
    private static final Logger theLogger = Logger.getLogger(JMSAvroAsyncReceiverLifecycle.class.getName());
    private static final String theSession = "session";
    private static final String theDestination = "destination";
    private Adapter<Rec, Msg> myAdapter;
    private Class<Rec> myRecordClass;
    private Schema myRecordSchema;

    public JMSAvroAsyncReceiverLifecycle(Adapter<Rec, Msg> adapter, Class<Msg> messageClass, Class<Rec> recordClass, Schema recordSchema, String receiverId, String connectionId, String destinationId) {
        super(new DescriptorListBuilder().dependency(theSession, Session.class).with("connectionId", connectionId).dependency(theDestination, Destination.class).with("destinationId", destinationId).getDescriptors());
        if (adapter == null || messageClass == null || recordClass == null || recordSchema == null) {
            throw new NullPointerException();
        }
        this.myAdapter = adapter;
        this.myRecordClass = recordClass;
        this.myRecordSchema = recordSchema;
        if (this.myRegistrationProperties == null) {
            this.myRegistrationProperties = new Properties();
        }
        this.myRegistrationProperties.put("messageType", messageClass.getName());
        this.myRegistrationProperties.put("recordType", recordClass.getName());
        this.myRegistrationProperties.put("messageReceiverId", receiverId);
    }

    protected DefaultMessageAsyncReceiver<Msg, Rec> create(Map<String, Object> dependencies) {
        MessageConsumer consumer;
        Session session = (Session)dependencies.get(theSession);
        Destination dest = (Destination)dependencies.get(theDestination);
        try {
            consumer = session.createConsumer(dest);
        }
        catch (JMSException ex) {
            theLogger.log(Level.WARNING, "Error creating JMS Consumer.", ex);
            return null;
        }
        DefaultMessageAsyncReceiver receiver = new DefaultMessageAsyncReceiver();
        JMSAvroRecordAsyncReceiver<Rec> pollingService = new JMSAvroRecordAsyncReceiver<Rec>(this.myRecordClass, this.myRecordSchema, consumer);
        receiver.setAdapter(this.myAdapter);
        receiver.setRecordReceiver(pollingService);
        try {
            receiver.start();
        }
        catch (Exception ex) {
            theLogger.log(Level.WARNING, "Error starting MessageReciever.", ex);
            return null;
        }
        return receiver;
    }

    protected void handleChange(String dependencyId, Object service, Map<String, Object> dependencies) {
        if (this.myService == null) {
            if (this.isSatisfied()) {
                this.myService = this.create(dependencies);
            }
            return;
        }
        ((DefaultMessageAsyncReceiver)this.myService).stop();
        this.myService = this.isSatisfied() ? this.create(dependencies) : null;
    }

    public Class<MessageAsyncReceiver> getServiceClass() {
        return MessageAsyncReceiver.class;
    }
}

