/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging.utils;

public class DestinationConfig {
    public static final int TYPE_QUEUE = 0;
    public static final int TYPE_TOPIC = 1;
    private String myDestinationId;
    private String myDestinationString;

    public static DestinationConfig build(String id, String destinationName, int type) {
        if (id == null || destinationName == null) {
            throw new NullPointerException();
        }
        String destStr = DestinationConfig.buildNameString(destinationName, type);
        return new DestinationConfig(id, destStr);
    }

    public static DestinationConfig buildQueue(String id, String destinationName) {
        return DestinationConfig.build(id, destinationName, 0);
    }

    public static DestinationConfig buildTopic(String id, String destinationName) {
        return DestinationConfig.build(id, destinationName, 0);
    }

    private static void validateType(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Invalid type: " + type + ".  " + "See DestinationDescriptor for available types.");
        }
    }

    private static String buildNameString(String destName, int type) {
        DestinationConfig.validateType(type);
        String fullName = destName;
        if (type == 0) {
            fullName = fullName + "; {create: always, node: {type: queue}}";
        } else if (type == 1) {
            fullName = fullName + "; {create: always, node: {type: topic}}";
        }
        return fullName;
    }

    public DestinationConfig(String destinationId, String destinationStr) {
        if (destinationId == null || destinationStr == null) {
            throw new NullPointerException();
        }
        this.myDestinationId = destinationId;
        this.myDestinationString = destinationStr;
    }

    public String getDestinationId() {
        return this.myDestinationId;
    }

    public String getDestinationString() {
        return this.myDestinationString;
    }
}

