/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging;

import javax.jms.BytesMessage;
import javax.jms.MessageConsumer;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.robokind.api.messaging.RecordAsyncReceiver;
import org.robokind.bind.apache_qpid.QpidUtils;
import org.robokind.impl.messaging.JMSBytesRecordAsyncReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSAvroRecordAsyncReceiver<Rec extends IndexedRecord>
implements RecordAsyncReceiver<Rec> {
    private static final Logger theLogger = LoggerFactory.getLogger(JMSAvroRecordAsyncReceiver.class);
    private Class<Rec> myClass;
    private Schema mySchema;
    private RecordAsyncReceiver.RecordHandler<Rec> myRecordHandler;
    private JMSBytesRecordAsyncReceiver myBytesReceiver;

    public JMSAvroRecordAsyncReceiver(Class<Rec> clazz, Schema schema, MessageConsumer consumer) {
        if (clazz == null || schema == null || consumer == null) {
            throw new NullPointerException();
        }
        this.myClass = clazz;
        this.mySchema = schema;
        this.myBytesReceiver = new JMSBytesRecordAsyncReceiver(consumer);
        this.myBytesReceiver.setRecordHandler(new AvroRecordHandler());
    }

    public void setRecordHandler(RecordAsyncReceiver.RecordHandler<Rec> handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.myRecordHandler = handler;
    }

    public void unsetRecordHandler() {
        this.myRecordHandler = null;
    }

    public void start() throws IllegalStateException {
        if (this.myRecordHandler == null) {
            throw new IllegalStateException("RecordHandler cannot be null.");
        }
        this.myBytesReceiver.start();
    }

    public void pause() {
        this.myBytesReceiver.pause();
    }

    public void resume() {
        this.myBytesReceiver.resume();
    }

    public void stop() {
        this.myBytesReceiver.stop();
    }

    class AvroRecordHandler
    implements RecordAsyncReceiver.RecordHandler<BytesMessage> {
        AvroRecordHandler() {
        }

        public void handleRecord(BytesMessage record) {
            IndexedRecord t;
            try {
                t = QpidUtils.unpackAvroMessage((Class)JMSAvroRecordAsyncReceiver.this.myClass, null, (Schema)JMSAvroRecordAsyncReceiver.this.mySchema, (BytesMessage)record);
            }
            catch (Exception ex) {
                theLogger.error("Error unpacking Message.", (Throwable)ex);
                return;
            }
            if (t == null) {
                theLogger.error("Error unpacking Message. Received null record.");
                return;
            }
            JMSAvroRecordAsyncReceiver.this.myRecordHandler.handleRecord((Object)t);
        }
    }
}

