/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging.config;

import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.config.Configuration;
import org.jflux.impl.encode.avro.SerializationConfigUtils;
import org.jflux.impl.transport.jms.ConnectionConfigUtils;
import org.robokind.api.common.lifecycle.ManagedService;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.ManagedServiceFactory;
import org.robokind.api.common.lifecycle.utils.SimpleLifecycle;

public class RKMessagingConfigUtils {
    public static final String JMS_CONNECTION_CONFIG = "messagingConnectionConfig";
    public static final String JMS_DESTINATION_CONFIG = "messagingDestinationConfig";
    public static final String SERIALIZATION_CONFIG = "messagingSerializationConfig";
    public static final String PROP_BROKER_IP = "brokerIpAddress";
    public static final String PROP_DESTINATION_NAME = "destinationName";
    public static final String PROP_DESTINATION_TYPE = "destinationType";
    public static final String AVRO_PREFIX = "avro";

    public static ManagedService registerConnectionConfig(String configId, Configuration<String> conf, Properties props, ManagedServiceFactory factory) {
        return RKMessagingConfigUtils.registerConfig(JMS_CONNECTION_CONFIG, configId, conf, props, factory);
    }

    public static ManagedService registerConnectionConfig(String configId, String ipAddress, String port, String username, String password, String clientName, String virtualHost, Properties props, ManagedServiceFactory factory) {
        Configuration conf = ConnectionConfigUtils.buildConnectionConfig((String)ipAddress, (String)port, (String)username, (String)password, (String)clientName, (String)virtualHost);
        props = props == null ? new Properties() : props;
        props.put(PROP_BROKER_IP, conf.getPropertyValue((Object)"msgBrokerIp"));
        return RKMessagingConfigUtils.registerConnectionConfig(configId, (Configuration<String>)conf, props, factory);
    }

    public static ManagedService registerConnectionConfig(String configId, String ipAddress, Properties props, ManagedServiceFactory factory) {
        return RKMessagingConfigUtils.registerConnectionConfig(configId, ipAddress, null, null, null, null, null, props, factory);
    }

    public static ManagedService registerDestinationConfig(String configId, Configuration<String> conf, Properties props, ManagedServiceFactory factory) {
        return RKMessagingConfigUtils.registerConfig(JMS_DESTINATION_CONFIG, configId, conf, props, factory);
    }

    public static ManagedService registerDestinationConfig(String configId, String name, String type, String create, String options, String nodeOptions, Properties props, ManagedServiceFactory factory) {
        Configuration conf = ConnectionConfigUtils.buildDestinationConfig((String)name, (String)type, (String)create, (String)options, (String)nodeOptions);
        props = props == null ? new Properties() : props;
        props.put(PROP_DESTINATION_NAME, conf.getPropertyValue((Object)"msgDestinationName"));
        props.put(PROP_DESTINATION_TYPE, conf.getPropertyValue((Object)"msgDestinationNodeType"));
        return RKMessagingConfigUtils.registerDestinationConfig(configId, (Configuration<String>)conf, props, factory);
    }

    public static ManagedService registerDestinationConfig(String configId, String name, String type, Properties props, ManagedServiceFactory factory) {
        return RKMessagingConfigUtils.registerDestinationConfig(configId, name, type, "always", null, null, props, factory);
    }

    public static ManagedService registerQueueConfig(String configId, String name, Properties props, ManagedServiceFactory factory) {
        return RKMessagingConfigUtils.registerDestinationConfig(configId, name, "queue", "always", null, null, props, factory);
    }

    public static ManagedService registerTopicConfig(String configId, String name, Properties props, ManagedServiceFactory factory) {
        return RKMessagingConfigUtils.registerDestinationConfig(configId, name, "topic", "always", null, null, props, factory);
    }

    public static <Msg, Rec> ManagedService registerSerializationConfig(Class<Msg> messageClass, Class<Rec> recordClass, Adapter<Msg, Rec> encoder, Adapter<Rec, Msg> decoder, String contentType, Properties props, ManagedServiceFactory factory) {
        Configuration conf = SerializationConfigUtils.buildSerializationConfig(messageClass, recordClass, encoder, decoder, (String)contentType);
        return RKMessagingConfigUtils.registerSerializationConfig(messageClass.toString(), (Configuration<String>)conf, props, factory);
    }

    public static <Msg, Rec extends IndexedRecord> ManagedService registerAvroSerializationConfig(Class<Msg> messageClass, Class<Rec> recordClass, Schema recordSchema, Adapter<Msg, Rec> encoder, Adapter<Rec, Msg> decoder, String contentType, Properties props, ManagedServiceFactory factory) {
        Configuration conf = SerializationConfigUtils.buildAvroSerializationConfig(messageClass, recordClass, encoder, decoder, (String)contentType, (Schema)recordSchema, (int)0);
        return RKMessagingConfigUtils.registerSerializationConfig(messageClass.toString(), (Configuration<String>)conf, props, factory);
    }

    public static ManagedService registerSerializationConfig(String configId, Configuration<String> conf, Properties props, ManagedServiceFactory factory) {
        props = props == null ? new Properties() : props;
        props.put(SERIALIZATION_CONFIG, configId);
        props.put("serializationMessageClass", conf.getPropertyValue((Object)"serializationMessageClass").toString());
        props.put("serializationRecordClass", conf.getPropertyValue((Object)"serializationRecordClass").toString());
        String contentType = (String)conf.getPropertyValue(String.class, (Object)"serializationContentType");
        if (contentType != null) {
            props.put("serializationContentType", contentType);
        }
        return RKMessagingConfigUtils.registerConfig(SERIALIZATION_CONFIG, configId, conf, props, factory);
    }

    static ManagedService registerConfig(String key, String id, Configuration<String> conf, Properties props, ManagedServiceFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        SimpleLifecycle lifecycle = new SimpleLifecycle(conf, Configuration.class, key, id, null);
        ManagedService service = factory.createService((ServiceLifecycleProvider)lifecycle, props);
        service.start();
        return service;
    }
}

