/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging.lifecycle;

import java.util.Map;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.avro.generic.IndexedRecord;
import org.jflux.api.core.Adapter;
import org.robokind.api.common.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.DescriptorListBuilder;
import org.robokind.api.messaging.MessageSender;
import org.robokind.impl.messaging.JMSAvroMessageSender;

public class JMSAvroMessageSenderLifecycle<Msg, Rec extends IndexedRecord>
extends AbstractLifecycleProvider<MessageSender, JMSAvroMessageSender<Msg, Rec>> {
    private Adapter<Msg, Rec> myAdapter;
    private String myDefaultContentType;
    protected static final String theSession = "session";
    protected static final String theDestination = "destination";

    public JMSAvroMessageSenderLifecycle(Adapter<Msg, Rec> adapter, Class<Msg> messageClass, Class<Rec> recordClass, String senderId, String sessionId, String destinationId, String contentType) {
        super(new DescriptorListBuilder().dependency(theSession, Session.class).with("connectionId", sessionId).dependency(theDestination, Destination.class).with("destinationId", destinationId).getDescriptors());
        if (adapter == null) {
            throw new NullPointerException();
        }
        this.myAdapter = adapter;
        this.myDefaultContentType = contentType;
        if (this.myRegistrationProperties == null) {
            this.myRegistrationProperties = new Properties();
        }
        this.myRegistrationProperties.put("messageType", messageClass.getName());
        this.myRegistrationProperties.put("recordType", recordClass.getName());
        this.myRegistrationProperties.put("messageSenderId", senderId);
    }

    public JMSAvroMessageSenderLifecycle(Adapter<Msg, Rec> adapter, Class<Msg> messageClass, Class<Rec> recordClass, String senderId, String sessionId, String destinationId) {
        this(adapter, messageClass, recordClass, senderId, sessionId, destinationId, null);
    }

    protected JMSAvroMessageSender<Msg, Rec> create(Map<String, Object> dependencies) {
        Session session = (Session)dependencies.get(theSession);
        Destination dest = (Destination)dependencies.get(theDestination);
        JMSAvroMessageSender sender = new JMSAvroMessageSender(session, dest);
        if (this.myDefaultContentType != null) {
            sender.setDefaultContentType(this.myDefaultContentType);
        }
        sender.setAdapter(this.myAdapter);
        sender.start();
        return sender;
    }

    public synchronized void stop() {
        if (this.myService != null) {
            ((JMSAvroMessageSender)((Object)this.myService)).stop();
        }
    }

    protected void handleChange(String dependencyId, Object service, Map<String, Object> dependencies) {
        if (this.myService == null) {
            return;
        }
        ((JMSAvroMessageSender)((Object)this.myService)).stop();
        this.myService = this.isSatisfied() ? this.create(dependencies) : null;
    }

    public Class<MessageSender> getServiceClass() {
        return MessageSender.class;
    }
}

