/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging.services;

import org.apache.avro.util.Utf8;
import org.jflux.api.core.Adapter;
import org.robokind.api.common.utils.TimeUtils;
import org.robokind.api.messaging.services.ServiceCommand;
import org.robokind.api.messaging.services.ServiceCommandFactory;
import org.robokind.avrogen.messaging.ServiceCommandRecord;

public class PortableServiceCommand
implements ServiceCommand {
    private ServiceCommandRecord myRecord;

    public PortableServiceCommand(ServiceCommandRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
    }

    public PortableServiceCommand(ServiceCommand command) {
        if (command == null) {
            throw new NullPointerException();
        }
        if (command instanceof PortableServiceCommand) {
            this.myRecord = ((PortableServiceCommand)command).getRecord();
            return;
        }
        this.setRecord(command.getSourceId(), command.getDestinationId(), command.getTimestampMillisecUTC(), command.getCommand());
    }

    public PortableServiceCommand(String sourceId, String destId, long timestampMillisecUTC, String command) {
        this.setRecord(sourceId, destId, timestampMillisecUTC, command);
    }

    private void setRecord(String sourceId, String destinationId, long timestampMillisecUTC, String command) {
        if (sourceId == null || destinationId == null || command == null) {
            throw new NullPointerException();
        }
        this.myRecord = new ServiceCommandRecord();
        this.myRecord.sourceId = new Utf8(sourceId);
        this.myRecord.destinationId = new Utf8(destinationId);
        this.myRecord.timestampMillisecUTC = timestampMillisecUTC;
        this.myRecord.command = new Utf8(command);
    }

    public String getSourceId() {
        return this.myRecord.sourceId.toString();
    }

    public String getDestinationId() {
        return this.myRecord.destinationId.toString();
    }

    public long getTimestampMillisecUTC() {
        return this.myRecord.timestampMillisecUTC;
    }

    public String getCommand() {
        return this.myRecord.command.toString();
    }

    public ServiceCommandRecord getRecord() {
        return this.myRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<ServiceCommandRecord, ServiceCommand> {
        public ServiceCommand adapt(ServiceCommandRecord a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableServiceCommand(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<ServiceCommand, ServiceCommandRecord> {
        public ServiceCommandRecord adapt(ServiceCommand a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableServiceCommand(a).getRecord();
        }
    }

    public static class Factory
    implements ServiceCommandFactory {
        public ServiceCommand create(String sourceId, String destId, String command) {
            return new PortableServiceCommand(sourceId, destId, TimeUtils.now(), command);
        }
    }
}

