/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging.services;

import org.apache.avro.util.Utf8;
import org.jflux.api.core.Adapter;
import org.robokind.api.messaging.services.ServiceError;
import org.robokind.avrogen.messaging.ServiceErrorRecord;

public class PortableServiceError
implements ServiceError {
    private ServiceErrorRecord myRecord;

    public PortableServiceError(ServiceErrorRecord record) {
        if (record == null) {
            throw new NullPointerException();
        }
        this.myRecord = record;
    }

    public PortableServiceError(ServiceError error) {
        if (error == null) {
            throw new NullPointerException();
        }
        if (error instanceof PortableServiceError) {
            this.myRecord = ((PortableServiceError)error).getRecord();
            return;
        }
        this.setRecord(error.getSourceId(), error.getDestinationId(), error.getTimestampMillisecUTC(), error.getErrorType(), error.getMessage(), error.getDetails());
    }

    public PortableServiceError(String sourceId, String destinationId, long timestampMillisecUTC, String errorType, String message, String details) {
        this.setRecord(sourceId, destinationId, timestampMillisecUTC, errorType, message, details);
    }

    private void setRecord(String sourceId, String destinationId, long timestampMillisecUTC, String errorType, String message, String details) {
        if (sourceId == null || destinationId == null || errorType == null) {
            throw new NullPointerException();
        }
        this.myRecord = new ServiceErrorRecord();
        this.myRecord.sourceId = new Utf8(sourceId);
        this.myRecord.destinationId = new Utf8(destinationId);
        this.myRecord.timestampMillisecUTC = timestampMillisecUTC;
        this.myRecord.errorType = new Utf8(errorType);
        this.myRecord.message = new Utf8(message == null ? "" : message);
        this.myRecord.details = new Utf8(details == null ? "" : details);
    }

    public String getSourceId() {
        return this.myRecord.sourceId.toString();
    }

    public String getDestinationId() {
        return this.myRecord.destinationId.toString();
    }

    public long getTimestampMillisecUTC() {
        return this.myRecord.timestampMillisecUTC;
    }

    public String getErrorType() {
        return this.myRecord.errorType.toString();
    }

    public String getMessage() {
        return this.myRecord.message.toString();
    }

    public String getDetails() {
        return this.myRecord.details.toString();
    }

    public ServiceErrorRecord getRecord() {
        return this.myRecord;
    }

    public static class RecordMessageAdapter
    implements Adapter<ServiceErrorRecord, ServiceError> {
        public ServiceError adapt(ServiceErrorRecord a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableServiceError(a);
        }
    }

    public static class MessageRecordAdapter
    implements Adapter<ServiceError, ServiceErrorRecord> {
        public ServiceErrorRecord adapt(ServiceError a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return new PortableServiceError(a).getRecord();
        }
    }
}

