/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging.utils;

import java.net.URISyntaxException;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.Destination;
import org.apache.qpid.client.AMQAnyDestination;
import org.apache.qpid.client.AMQConnectionFactory;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQTopic;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.osgi.OSGiUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager {
    private static final Logger theLogger = LoggerFactory.getLogger(ConnectionManager.class);
    private static final String theAMQPFormatString = "amqp://%s:%s@%s/%s?brokerlist='%s'";
    public static final String PROP_CONNECTION_ID = "connectionId";
    public static final String PROP_DESTINATION_ID = "destinationId";

    public static String createAMQPConnectionURL(String username, String password, String clientName, String virtualHost, String tcpAddress) {
        return String.format(theAMQPFormatString, username, password, clientName, virtualHost, tcpAddress);
    }

    public static Connection createConnection(String username, String password, String clientName, String virtualHost, String tcpAddress) {
        String amqpURL = ConnectionManager.createAMQPConnectionURL(username, password, clientName, virtualHost, tcpAddress);
        return ConnectionManager.createConnection(amqpURL);
    }

    public static Connection createConnection(String amqpURL) {
        try {
            String reconnectOptions = "&connectdelay='5000'&retries='2147483647'";
            amqpURL = amqpURL + reconnectOptions;
            AMQConnectionFactory cf = new AMQConnectionFactory(amqpURL);
            return cf.createConnection();
        }
        catch (Exception ex) {
            theLogger.warn("Unable to create connection.", (Throwable)ex);
            return null;
        }
    }

    public static Destination createDestination(String destinationStr) {
        try {
            return new AMQAnyDestination(destinationStr);
        }
        catch (URISyntaxException ex) {
            theLogger.warn("Unable to create destination.", (Throwable)ex);
            return null;
        }
    }

    public static Destination createQueue(String destinationStr) {
        try {
            return new AMQQueue(destinationStr);
        }
        catch (URISyntaxException ex) {
            theLogger.warn("Unable to create destination.", (Throwable)ex);
            return null;
        }
    }

    public static Destination createTopic(String destinationStr) {
        try {
            return new AMQTopic(destinationStr);
        }
        catch (URISyntaxException ex) {
            theLogger.warn("Unable to create destination.", (Throwable)ex);
            return null;
        }
    }

    public static ServiceRegistration registerConnection(BundleContext context, String connectionId, Connection connection, Properties props) {
        if (context == null || connection == null) {
            throw new NullPointerException();
        }
        return OSGiUtils.registerUniqueService((BundleContext)context, (String)Connection.class.getName(), (String)PROP_CONNECTION_ID, (String)connectionId, (Object)connection, (Properties)props);
    }

    public static ServiceRegistration registerDestination(BundleContext context, String destinationId, Destination destination, Properties props) {
        if (context == null || destination == null) {
            throw new NullPointerException();
        }
        return OSGiUtils.registerUniqueService((BundleContext)context, (String)Destination.class.getName(), (String)PROP_DESTINATION_ID, (String)destinationId, (Object)destination, (Properties)props);
    }
}

