/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging.utils;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.impl.messaging.utils.ConnectionManager;

public class ConnectionUtils {
    private static final Logger theLogger = Logger.getLogger(ConnectionUtils.class.getName());
    public static final int QUEUE = 0;
    public static final int TOPIC = 1;

    public static boolean ensureSession(BundleContext context, String conId, Connection con, Properties props) {
        Session session;
        if (con == null) {
            throw new NullPointerException();
        }
        ConnectionUtils.ensureConnection(context, conId, con, props);
        if (OSGiUtils.serviceExists((BundleContext)context, (String)Session.class.getName(), (String)"connectionId", (String)conId, (Properties)props).booleanValue()) {
            theLogger.log(Level.INFO, "Connection for Id: {0} alreaday exists.  No need to create new Connection.", conId);
            return true;
        }
        try {
            session = con.createSession(false, 2);
        }
        catch (JMSException ex) {
            theLogger.log(Level.WARNING, "Unable to create session.", ex);
            return false;
        }
        ServiceRegistration reg = OSGiUtils.registerUniqueService((BundleContext)context, (String)Session.class.getName(), (String)"connectionId", (String)conId, (Object)session, (Properties)props);
        if (reg == null) {
            theLogger.log(Level.WARNING, "Unable to register connection with Id: {0}.", conId);
            return false;
        }
        theLogger.log(Level.INFO, "Connection with Id: {0} registered successfully.", conId);
        return true;
    }

    public static boolean ensureConnection(BundleContext context, String conId, Connection con, Properties props) {
        if (con == null) {
            throw new NullPointerException();
        }
        if (OSGiUtils.serviceExists((BundleContext)context, (String)Connection.class.getName(), (String)"connectionId", (String)conId, (Properties)props).booleanValue()) {
            theLogger.log(Level.INFO, "Connection for Id: {0} alreaday exists.  No need to create new Connection.", conId);
            return true;
        }
        ServiceRegistration reg = ConnectionManager.registerConnection(context, conId, con, props);
        if (reg == null) {
            theLogger.log(Level.WARNING, "Unable to register connection with Id: {0}.", conId);
            return false;
        }
        theLogger.log(Level.INFO, "Connection with Id: {0} registered successfully.", conId);
        return true;
    }

    public static boolean ensureDestination(BundleContext context, String destId, String destName, int type, Properties props) {
        if (OSGiUtils.serviceExists((BundleContext)context, (String)Destination.class.getName(), (String)"destinationId", (String)destId, (Properties)props).booleanValue()) {
            theLogger.log(Level.INFO, "Destination for Id: {0} alreaday exists.  No need to create new Destination.", destId);
            return true;
        }
        String destStr = ConnectionUtils.buildNameString(destName, type);
        Destination dest = ConnectionManager.createDestination(destStr);
        if (dest == null) {
            theLogger.log(Level.WARNING, "Unable to create destination with Id: {0}.", destId);
            return false;
        }
        ServiceRegistration reg = ConnectionManager.registerDestination(context, destId, dest, props);
        if (reg == null) {
            theLogger.log(Level.WARNING, "Unable to register destination with Id: {0}.", destId);
            return false;
        }
        theLogger.log(Level.INFO, "Destination with Id: {0} registered successfully.", destId);
        return true;
    }

    public static void ensureDestinations(BundleContext context, Object ... destParams) {
        int len = destParams.length;
        if (len == 0 || len % 4 != 0) {
            throw new IllegalArgumentException("Wrong number of param strings.  Expecting id/destination/type/properties triplets.");
        }
        for (int i = 0; i < len - 3; i += 4) {
            String id = ConnectionUtils.check(String.class, destParams[i]);
            String destStr = ConnectionUtils.check(String.class, destParams[i + 1]);
            Integer type = ConnectionUtils.check(Integer.class, destParams[i + 2]);
            Properties props = ConnectionUtils.check(Properties.class, destParams[i + 3]);
            ConnectionUtils.ensureDestination(context, id, destStr, type, props);
        }
    }

    private static <T> T check(Class<T> clazz, Object obj) {
        if (obj == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("Expected: " + clazz.getName() + ".  Got: " + obj.getClass());
        }
        return (T)obj;
    }

    private static String buildNameString(String destName, int type) {
        String fullName = destName;
        if (type == 0) {
            fullName = fullName + "; {create: always, node: {type: queue}}";
        } else if (type == 1) {
            fullName = fullName + "; {create: always, node: {type: topic}}";
        }
        return fullName;
    }
}

