/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging.lifecycle;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.jflux.api.core.Adapter;
import org.robokind.api.common.lifecycle.AbstractLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.DescriptorListBuilder;
import org.robokind.api.messaging.DefaultMessageBlockingReceiver;
import org.robokind.api.messaging.MessageBlockingReceiver;
import org.robokind.api.messaging.RecordBlockingReceiver;
import org.robokind.impl.messaging.JMSBytesRecordBlockingReceiver;

public class BytesMessageBlockingReceiverLifecycle<Msg>
extends AbstractLifecycleProvider<MessageBlockingReceiver, DefaultMessageBlockingReceiver<Msg, BytesMessage>> {
    private static final Logger theLogger = Logger.getLogger(BytesMessageBlockingReceiverLifecycle.class.getName());
    private static final String theSession = "session";
    private static final String theDestination = "destination";
    private Adapter<BytesMessage, Msg> myAdapter;

    public BytesMessageBlockingReceiverLifecycle(Adapter<BytesMessage, Msg> adapter, Class<Msg> messageClass, String receiverId, String sessionId, String destinationId) {
        super(new DescriptorListBuilder().dependency(theSession, Session.class).with("connectionId", sessionId).dependency(theDestination, Destination.class).with("destinationId", destinationId).getDescriptors());
        if (adapter == null) {
            throw new NullPointerException();
        }
        this.myAdapter = adapter;
        if (this.myRegistrationProperties == null) {
            this.myRegistrationProperties = new Properties();
        }
        this.myRegistrationProperties.put("messageType", messageClass.getName());
        this.myRegistrationProperties.put("recordType", BytesMessage.class.getName());
        this.myRegistrationProperties.put("messageReceiverId", receiverId);
    }

    protected DefaultMessageBlockingReceiver<Msg, BytesMessage> create(Map<String, Object> dependencies) {
        MessageConsumer consumer;
        Session session = (Session)dependencies.get(theSession);
        Destination destination = (Destination)dependencies.get(theDestination);
        try {
            consumer = session.createConsumer(destination);
        }
        catch (JMSException ex) {
            theLogger.log(Level.WARNING, "Error creating JMS Consumer.", ex);
            return null;
        }
        DefaultMessageBlockingReceiver receiver = new DefaultMessageBlockingReceiver();
        JMSBytesRecordBlockingReceiver recReceiver = new JMSBytesRecordBlockingReceiver(consumer);
        receiver.setRecordReceiver((RecordBlockingReceiver)recReceiver);
        receiver.setAdapter(this.myAdapter);
        return receiver;
    }

    protected void handleChange(String dependencyId, Object service, Map<String, Object> dependencies) {
        if (this.myService == null) {
            if (this.isSatisfied()) {
                this.myService = this.create(dependencies);
            }
            return;
        }
        ((DefaultMessageBlockingReceiver)this.myService).stop();
        this.myService = this.isSatisfied() ? this.create(dependencies) : null;
    }

    public Class<MessageBlockingReceiver> getServiceClass() {
        return MessageBlockingReceiver.class;
    }
}

