/*
 * Decompiled with CFR 0.152.
 */
package org.robokind.impl.messaging.config;

import javax.jms.BytesMessage;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.jflux.api.core.Adapter;
import org.jflux.api.core.config.Configuration;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.messaging.MessageAsyncReceiver;
import org.robokind.api.messaging.MessageBlockingReceiver;
import org.robokind.api.messaging.MessageSender;
import org.robokind.impl.messaging.lifecycle.BytesMessageBlockingReceiverLifecycle;
import org.robokind.impl.messaging.lifecycle.JMSAvroAsyncReceiverLifecycle;
import org.robokind.impl.messaging.lifecycle.JMSAvroMessageSenderLifecycle;
import org.robokind.impl.messaging.lifecycle.JMSAvroPolymorphicSenderLifecycle;
import org.robokind.impl.messaging.utils.JMSAvroPolymorphicRecordBytesAdapter;

public class RKMessagingComponentConfigUtils {
    public static <Msg, Rec extends IndexedRecord> ServiceLifecycleProvider<MessageSender> buildAvroRemoteNotifierLifecycle(String remoteNotifierId, String destinatinId, String sessionId, Configuration<String> avroConfig) {
        Class messageClass = (Class)avroConfig.getPropertyValue(Class.class, (Object)"serializationMessageClass");
        Class recordClass = (Class)avroConfig.getPropertyValue(Class.class, (Object)"serializationRecordClass");
        Adapter encoder = (Adapter)avroConfig.getPropertyValue(Adapter.class, (Object)"serializationSenderEncoderAdapter");
        String contentType = (String)avroConfig.getPropertyValue(String.class, (Object)"serializationContentType");
        return new JMSAvroMessageSenderLifecycle(encoder, messageClass, recordClass, remoteNotifierId, sessionId, destinatinId, contentType);
    }

    public static <Msg, Rec extends IndexedRecord> ServiceLifecycleProvider<MessageAsyncReceiver> buildAvroRemoteListenerLifecycle(String remoteListenerId, String destinatinId, String sessionId, Configuration<String> avroConfig) {
        Class messageClass = (Class)avroConfig.getPropertyValue(Class.class, (Object)"serializationMessageClass");
        Class recordClass = (Class)avroConfig.getPropertyValue(Class.class, (Object)"serializationRecordClass");
        Adapter decoder = (Adapter)avroConfig.getPropertyValue(Adapter.class, (Object)"serializationReceiverDecoderAdapter");
        Schema recordSchema = (Schema)avroConfig.getPropertyValue(Schema.class, (Object)"avroRecordSchema");
        return new JMSAvroAsyncReceiverLifecycle(decoder, messageClass, recordClass, recordSchema, remoteListenerId, sessionId, destinatinId);
    }

    public static <Msg> ServiceLifecycleProvider<MessageBlockingReceiver> buildJMSRemoteSourceLifecycle(String remoteSourceId, String destinatinId, String sessionId, Configuration<String> config) {
        Class recordClass = (Class)config.getPropertyValue(Class.class, (Object)"serializationRecordClass");
        if (!recordClass.isAssignableFrom(BytesMessage.class)) {
            throw new UnsupportedOperationException();
        }
        Class messageClass = (Class)config.getPropertyValue(Class.class, (Object)"serializationMessageClass");
        Adapter decoder = (Adapter)config.getPropertyValue(Adapter.class, (Object)"serializationReceiverDecoderAdapter");
        return new BytesMessageBlockingReceiverLifecycle(decoder, messageClass, remoteSourceId, sessionId, destinatinId);
    }

    public static <Msg> ServiceLifecycleProvider<MessageSender> buildJMSAvroPolymorphicRemoteNotifierLifecycle(String remoteNotifierId, String destinatinId, String sessionId, Configuration<String> config) {
        Class messageClass = (Class)config.getPropertyValue(Class.class, (Object)"serializationMessageClass");
        JMSAvroPolymorphicRecordBytesAdapter decoder = (JMSAvroPolymorphicRecordBytesAdapter)config.getPropertyValue(Adapter.class, (Object)"serializationReceiverDecoderAdapter");
        return new JMSAvroPolymorphicSenderLifecycle(decoder, messageClass, remoteNotifierId, sessionId, destinatinId);
    }
}

